/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input parameters for privacy budget templates that support access budgets functionality, enabling enhanced budget
 * management capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessBudgetsPrivacyTemplateParametersInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessBudgetsPrivacyTemplateParametersInput.Builder, AccessBudgetsPrivacyTemplateParametersInput> {
    private static final SdkField<List<BudgetParameter>> BUDGET_PARAMETERS_FIELD = SdkField
            .<List<BudgetParameter>> builder(MarshallingType.LIST)
            .memberName("budgetParameters")
            .getter(getter(AccessBudgetsPrivacyTemplateParametersInput::budgetParameters))
            .setter(setter(Builder::budgetParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(AccessBudgetsPrivacyTemplateParametersInput::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_PARAMETERS_FIELD,
            RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<BudgetParameter> budgetParameters;

    private final String resourceArn;

    private AccessBudgetsPrivacyTemplateParametersInput(BuilderImpl builder) {
        this.budgetParameters = builder.budgetParameters;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the BudgetParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBudgetParameters() {
        return budgetParameters != null && !(budgetParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of budget parameters that define the access budget configuration for the privacy template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBudgetParameters} method.
     * </p>
     * 
     * @return An array of budget parameters that define the access budget configuration for the privacy template.
     */
    public final List<BudgetParameter> budgetParameters() {
        return budgetParameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource associated with this privacy budget template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource associated with this privacy budget template.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBudgetParameters() ? budgetParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessBudgetsPrivacyTemplateParametersInput)) {
            return false;
        }
        AccessBudgetsPrivacyTemplateParametersInput other = (AccessBudgetsPrivacyTemplateParametersInput) obj;
        return hasBudgetParameters() == other.hasBudgetParameters()
                && Objects.equals(budgetParameters(), other.budgetParameters())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessBudgetsPrivacyTemplateParametersInput")
                .add("BudgetParameters", hasBudgetParameters() ? budgetParameters() : null).add("ResourceArn", resourceArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "budgetParameters":
            return Optional.ofNullable(clazz.cast(budgetParameters()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("budgetParameters", BUDGET_PARAMETERS_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessBudgetsPrivacyTemplateParametersInput, T> g) {
        return obj -> g.apply((AccessBudgetsPrivacyTemplateParametersInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessBudgetsPrivacyTemplateParametersInput> {
        /**
         * <p>
         * An array of budget parameters that define the access budget configuration for the privacy template.
         * </p>
         * 
         * @param budgetParameters
         *        An array of budget parameters that define the access budget configuration for the privacy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetParameters(Collection<BudgetParameter> budgetParameters);

        /**
         * <p>
         * An array of budget parameters that define the access budget configuration for the privacy template.
         * </p>
         * 
         * @param budgetParameters
         *        An array of budget parameters that define the access budget configuration for the privacy template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetParameters(BudgetParameter... budgetParameters);

        /**
         * <p>
         * An array of budget parameters that define the access budget configuration for the privacy template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.BudgetParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cleanrooms.model.BudgetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.BudgetParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #budgetParameters(List<BudgetParameter>)}.
         * 
         * @param budgetParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.BudgetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgetParameters(java.util.Collection<BudgetParameter>)
         */
        Builder budgetParameters(Consumer<BudgetParameter.Builder>... budgetParameters);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource associated with this privacy budget template.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource associated with this privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private List<BudgetParameter> budgetParameters = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessBudgetsPrivacyTemplateParametersInput model) {
            budgetParameters(model.budgetParameters);
            resourceArn(model.resourceArn);
        }

        public final List<BudgetParameter.Builder> getBudgetParameters() {
            List<BudgetParameter.Builder> result = BudgetParametersCopier.copyToBuilder(this.budgetParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgetParameters(Collection<BudgetParameter.BuilderImpl> budgetParameters) {
            this.budgetParameters = BudgetParametersCopier.copyFromBuilder(budgetParameters);
        }

        @Override
        public final Builder budgetParameters(Collection<BudgetParameter> budgetParameters) {
            this.budgetParameters = BudgetParametersCopier.copy(budgetParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetParameters(BudgetParameter... budgetParameters) {
            budgetParameters(Arrays.asList(budgetParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetParameters(Consumer<BudgetParameter.Builder>... budgetParameters) {
            budgetParameters(Stream.of(budgetParameters).map(c -> BudgetParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public AccessBudgetsPrivacyTemplateParametersInput build() {
            return new AccessBudgetsPrivacyTemplateParametersInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
