/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleTypeListCopier;
import software.amazon.awssdk.services.cleanrooms.model.SchemaType;
import software.amazon.awssdk.services.cleanrooms.model.SelectedAnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.SelectedAnalysisMethodsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SchemaSummary.getter(SchemaSummary::name)).setter(SchemaSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SchemaSummary.getter(SchemaSummary::typeAsString)).setter(SchemaSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(SchemaSummary.getter(SchemaSummary::creatorAccountId)).setter(SchemaSummary.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(SchemaSummary.getter(SchemaSummary::createTime)).setter(SchemaSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(SchemaSummary.getter(SchemaSummary::updateTime)).setter(SchemaSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(SchemaSummary.getter(SchemaSummary::collaborationId)).setter(SchemaSummary.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationArn").getter(SchemaSummary.getter(SchemaSummary::collaborationArn)).setter(SchemaSummary.setter(Builder::collaborationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisRuleTypes").getter(SchemaSummary.getter(SchemaSummary::analysisRuleTypesAsStrings)).setter(SchemaSummary.setter(Builder::analysisRuleTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisMethod").getter(SchemaSummary.getter(SchemaSummary::analysisMethodAsString)).setter(SchemaSummary.setter(Builder::analysisMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(SchemaSummary.getter(SchemaSummary::resourceArn)).setter(SchemaSummary.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<List<String>> SELECTED_ANALYSIS_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedAnalysisMethods").getter(SchemaSummary.getter(SchemaSummary::selectedAnalysisMethodsAsStrings)).setter(SchemaSummary.setter(Builder::selectedAnalysisMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedAnalysisMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, CREATOR_ACCOUNT_ID_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, ANALYSIS_RULE_TYPES_FIELD, ANALYSIS_METHOD_FIELD, RESOURCE_ARN_FIELD, SELECTED_ANALYSIS_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String creatorAccountId;
    private final Instant createTime;
    private final Instant updateTime;
    private final String collaborationId;
    private final String collaborationArn;
    private final List<String> analysisRuleTypes;
    private final String analysisMethod;
    private final String resourceArn;
    private final List<String> selectedAnalysisMethods;

    private SchemaSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.creatorAccountId = builder.creatorAccountId;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.analysisMethod = builder.analysisMethod;
        this.resourceArn = builder.resourceArn;
        this.selectedAnalysisMethods = builder.selectedAnalysisMethods;
    }

    public final String name() {
        return this.name;
    }

    public final SchemaType type() {
        return SchemaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String collaborationArn() {
        return this.collaborationArn;
    }

    public final List<AnalysisRuleType> analysisRuleTypes() {
        return AnalysisRuleTypeListCopier.copyStringToEnum(this.analysisRuleTypes);
    }

    public final boolean hasAnalysisRuleTypes() {
        return this.analysisRuleTypes != null && !(this.analysisRuleTypes instanceof SdkAutoConstructList);
    }

    public final List<String> analysisRuleTypesAsStrings() {
        return this.analysisRuleTypes;
    }

    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(this.analysisMethod);
    }

    public final String analysisMethodAsString() {
        return this.analysisMethod;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final List<SelectedAnalysisMethod> selectedAnalysisMethods() {
        return SelectedAnalysisMethodsCopier.copyStringToEnum(this.selectedAnalysisMethods);
    }

    public final boolean hasSelectedAnalysisMethods() {
        return this.selectedAnalysisMethods != null && !(this.selectedAnalysisMethods instanceof SdkAutoConstructList);
    }

    public final List<String> selectedAnalysisMethodsAsStrings() {
        return this.selectedAnalysisMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedAnalysisMethods() ? this.selectedAnalysisMethodsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaSummary)) {
            return false;
        }
        SchemaSummary other = (SchemaSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.collaborationArn(), other.collaborationArn()) && this.hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes() && Objects.equals(this.analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings()) && Objects.equals(this.analysisMethodAsString(), other.analysisMethodAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasSelectedAnalysisMethods() == other.hasSelectedAnalysisMethods() && Objects.equals(this.selectedAnalysisMethodsAsStrings(), other.selectedAnalysisMethodsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaSummary").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("CreatorAccountId", (Object)this.creatorAccountId()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("CollaborationId", (Object)this.collaborationId()).add("CollaborationArn", (Object)this.collaborationArn()).add("AnalysisRuleTypes", this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null).add("AnalysisMethod", (Object)this.analysisMethodAsString()).add("ResourceArn", (Object)this.resourceArn()).add("SelectedAnalysisMethods", this.hasSelectedAnalysisMethods() ? this.selectedAnalysisMethodsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "collaborationArn": {
                return Optional.ofNullable(clazz.cast(this.collaborationArn()));
            }
            case "analysisRuleTypes": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypesAsStrings()));
            }
            case "analysisMethod": {
                return Optional.ofNullable(clazz.cast(this.analysisMethodAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "selectedAnalysisMethods": {
                return Optional.ofNullable(clazz.cast(this.selectedAnalysisMethodsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("analysisRuleTypes", ANALYSIS_RULE_TYPES_FIELD);
        map.put("analysisMethod", ANALYSIS_METHOD_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("selectedAnalysisMethods", SELECTED_ANALYSIS_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaSummary, T> g) {
        return obj -> g.apply((SchemaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String creatorAccountId;
        private Instant createTime;
        private Instant updateTime;
        private String collaborationId;
        private String collaborationArn;
        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();
        private String analysisMethod;
        private String resourceArn;
        private List<String> selectedAnalysisMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaSummary model) {
            this.name(model.name);
            this.type(model.type);
            this.creatorAccountId(model.creatorAccountId);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.collaborationId(model.collaborationId);
            this.collaborationArn(model.collaborationArn);
            this.analysisRuleTypesWithStrings(model.analysisRuleTypes);
            this.analysisMethod(model.analysisMethod);
            this.resourceArn(model.resourceArn);
            this.selectedAnalysisMethodsWithStrings(model.selectedAnalysisMethods);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return this.collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (this.analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String ... analysisRuleTypes) {
            this.analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<AnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = AnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(AnalysisRuleType ... analysisRuleTypes) {
            this.analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final String getAnalysisMethod() {
            return this.analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Collection<String> getSelectedAnalysisMethods() {
            if (this.selectedAnalysisMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedAnalysisMethods;
        }

        public final void setSelectedAnalysisMethods(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
        }

        @Override
        public final Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethodsWithStrings(String ... selectedAnalysisMethods) {
            this.selectedAnalysisMethodsWithStrings(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public final Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copyEnumToString(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethods(SelectedAnalysisMethod ... selectedAnalysisMethods) {
            this.selectedAnalysisMethods(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        public SchemaSummary build() {
            return new SchemaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaSummary> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(SchemaType var1);

        public Builder creatorAccountId(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder collaborationId(String var1);

        public Builder collaborationArn(String var1);

        public Builder analysisRuleTypesWithStrings(Collection<String> var1);

        public Builder analysisRuleTypesWithStrings(String ... var1);

        public Builder analysisRuleTypes(Collection<AnalysisRuleType> var1);

        public Builder analysisRuleTypes(AnalysisRuleType ... var1);

        public Builder analysisMethod(String var1);

        public Builder analysisMethod(AnalysisMethod var1);

        public Builder resourceArn(String var1);

        public Builder selectedAnalysisMethodsWithStrings(Collection<String> var1);

        public Builder selectedAnalysisMethodsWithStrings(String ... var1);

        public Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> var1);

        public Builder selectedAnalysisMethods(SelectedAnalysisMethod ... var1);
    }
}

