/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationChangeRequestsResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListCollaborationChangeRequestsResponse> {
    private static final SdkField<List<CollaborationChangeRequestSummary>> COLLABORATION_CHANGE_REQUEST_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationChangeRequestSummaries").getter(ListCollaborationChangeRequestsResponse.getter(ListCollaborationChangeRequestsResponse::collaborationChangeRequestSummaries)).setter(ListCollaborationChangeRequestsResponse.setter(Builder::collaborationChangeRequestSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationChangeRequestSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationChangeRequestSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationChangeRequestsResponse.getter(ListCollaborationChangeRequestsResponse::nextToken)).setter(ListCollaborationChangeRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_CHANGE_REQUEST_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollaborationChangeRequestsResponse.memberNameToFieldInitializer();
    private final List<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries;
    private final String nextToken;

    private ListCollaborationChangeRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationChangeRequestSummaries = builder.collaborationChangeRequestSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCollaborationChangeRequestSummaries() {
        return this.collaborationChangeRequestSummaries != null && !(this.collaborationChangeRequestSummaries instanceof SdkAutoConstructList);
    }

    public final List<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries() {
        return this.collaborationChangeRequestSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationChangeRequestSummaries() ? this.collaborationChangeRequestSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationChangeRequestsResponse)) {
            return false;
        }
        ListCollaborationChangeRequestsResponse other = (ListCollaborationChangeRequestsResponse)((Object)obj);
        return this.hasCollaborationChangeRequestSummaries() == other.hasCollaborationChangeRequestSummaries() && Objects.equals(this.collaborationChangeRequestSummaries(), other.collaborationChangeRequestSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationChangeRequestsResponse").add("CollaborationChangeRequestSummaries", this.hasCollaborationChangeRequestSummaries() ? this.collaborationChangeRequestSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationChangeRequestSummaries": {
                return Optional.ofNullable(clazz.cast(this.collaborationChangeRequestSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collaborationChangeRequestSummaries", COLLABORATION_CHANGE_REQUEST_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationChangeRequestsResponse, T> g) {
        return obj -> g.apply((ListCollaborationChangeRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationChangeRequestsResponse model) {
            super(model);
            this.collaborationChangeRequestSummaries(model.collaborationChangeRequestSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<CollaborationChangeRequestSummary.Builder> getCollaborationChangeRequestSummaries() {
            List<CollaborationChangeRequestSummary.Builder> result = CollaborationChangeRequestSummaryListCopier.copyToBuilder(this.collaborationChangeRequestSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationChangeRequestSummaries(Collection<CollaborationChangeRequestSummary.BuilderImpl> collaborationChangeRequestSummaries) {
            this.collaborationChangeRequestSummaries = CollaborationChangeRequestSummaryListCopier.copyFromBuilder(collaborationChangeRequestSummaries);
        }

        @Override
        public final Builder collaborationChangeRequestSummaries(Collection<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries) {
            this.collaborationChangeRequestSummaries = CollaborationChangeRequestSummaryListCopier.copy(collaborationChangeRequestSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationChangeRequestSummaries(CollaborationChangeRequestSummary ... collaborationChangeRequestSummaries) {
            this.collaborationChangeRequestSummaries(Arrays.asList(collaborationChangeRequestSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationChangeRequestSummaries(Consumer<CollaborationChangeRequestSummary.Builder> ... collaborationChangeRequestSummaries) {
            this.collaborationChangeRequestSummaries(Stream.of(collaborationChangeRequestSummaries).map(c -> (CollaborationChangeRequestSummary)((CollaborationChangeRequestSummary.Builder)CollaborationChangeRequestSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollaborationChangeRequestsResponse build() {
            return new ListCollaborationChangeRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationChangeRequestsResponse> {
        public Builder collaborationChangeRequestSummaries(Collection<CollaborationChangeRequestSummary> var1);

        public Builder collaborationChangeRequestSummaries(CollaborationChangeRequestSummary ... var1);

        public Builder collaborationChangeRequestSummaries(Consumer<CollaborationChangeRequestSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

