/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.MembershipJobLogStatus;
import software.amazon.awssdk.services.cleanrooms.model.MembershipProtectedJobResultConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.MembershipProtectedQueryResultConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.MembershipQueryLogStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMembershipRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, UpdateMembershipRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::membershipIdentifier)).setter(UpdateMembershipRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLogStatus").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::queryLogStatusAsString)).setter(UpdateMembershipRequest.setter(Builder::queryLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()}).build();
    private static final SdkField<String> JOB_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobLogStatus").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::jobLogStatusAsString)).setter(UpdateMembershipRequest.setter(Builder::jobLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLogStatus").build()}).build();
    private static final SdkField<MembershipProtectedQueryResultConfiguration> DEFAULT_RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultResultConfiguration").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::defaultResultConfiguration)).setter(UpdateMembershipRequest.setter(Builder::defaultResultConfiguration)).constructor(MembershipProtectedQueryResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResultConfiguration").build()}).build();
    private static final SdkField<MembershipProtectedJobResultConfiguration> DEFAULT_JOB_RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultJobResultConfiguration").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::defaultJobResultConfiguration)).setter(UpdateMembershipRequest.setter(Builder::defaultJobResultConfiguration)).constructor(MembershipProtectedJobResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultJobResultConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, QUERY_LOG_STATUS_FIELD, JOB_LOG_STATUS_FIELD, DEFAULT_RESULT_CONFIGURATION_FIELD, DEFAULT_JOB_RESULT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMembershipRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String queryLogStatus;
    private final String jobLogStatus;
    private final MembershipProtectedQueryResultConfiguration defaultResultConfiguration;
    private final MembershipProtectedJobResultConfiguration defaultJobResultConfiguration;

    private UpdateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.queryLogStatus = builder.queryLogStatus;
        this.jobLogStatus = builder.jobLogStatus;
        this.defaultResultConfiguration = builder.defaultResultConfiguration;
        this.defaultJobResultConfiguration = builder.defaultJobResultConfiguration;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final MembershipQueryLogStatus queryLogStatus() {
        return MembershipQueryLogStatus.fromValue(this.queryLogStatus);
    }

    public final String queryLogStatusAsString() {
        return this.queryLogStatus;
    }

    public final MembershipJobLogStatus jobLogStatus() {
        return MembershipJobLogStatus.fromValue(this.jobLogStatus);
    }

    public final String jobLogStatusAsString() {
        return this.jobLogStatus;
    }

    public final MembershipProtectedQueryResultConfiguration defaultResultConfiguration() {
        return this.defaultResultConfiguration;
    }

    public final MembershipProtectedJobResultConfiguration defaultJobResultConfiguration() {
        return this.defaultJobResultConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultJobResultConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMembershipRequest)) {
            return false;
        }
        UpdateMembershipRequest other = (UpdateMembershipRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.queryLogStatusAsString(), other.queryLogStatusAsString()) && Objects.equals(this.jobLogStatusAsString(), other.jobLogStatusAsString()) && Objects.equals(this.defaultResultConfiguration(), other.defaultResultConfiguration()) && Objects.equals(this.defaultJobResultConfiguration(), other.defaultJobResultConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMembershipRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("QueryLogStatus", (Object)this.queryLogStatusAsString()).add("JobLogStatus", (Object)this.jobLogStatusAsString()).add("DefaultResultConfiguration", (Object)this.defaultResultConfiguration()).add("DefaultJobResultConfiguration", (Object)this.defaultJobResultConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "queryLogStatus": {
                return Optional.ofNullable(clazz.cast(this.queryLogStatusAsString()));
            }
            case "jobLogStatus": {
                return Optional.ofNullable(clazz.cast(this.jobLogStatusAsString()));
            }
            case "defaultResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultResultConfiguration()));
            }
            case "defaultJobResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultJobResultConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("queryLogStatus", QUERY_LOG_STATUS_FIELD);
        map.put("jobLogStatus", JOB_LOG_STATUS_FIELD);
        map.put("defaultResultConfiguration", DEFAULT_RESULT_CONFIGURATION_FIELD);
        map.put("defaultJobResultConfiguration", DEFAULT_JOB_RESULT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMembershipRequest, T> g) {
        return obj -> g.apply((UpdateMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String queryLogStatus;
        private String jobLogStatus;
        private MembershipProtectedQueryResultConfiguration defaultResultConfiguration;
        private MembershipProtectedJobResultConfiguration defaultJobResultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMembershipRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.queryLogStatus(model.queryLogStatus);
            this.jobLogStatus(model.jobLogStatus);
            this.defaultResultConfiguration(model.defaultResultConfiguration);
            this.defaultJobResultConfiguration(model.defaultJobResultConfiguration);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final String getJobLogStatus() {
            return this.jobLogStatus;
        }

        public final void setJobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
        }

        @Override
        public final Builder jobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
            return this;
        }

        @Override
        public final Builder jobLogStatus(MembershipJobLogStatus jobLogStatus) {
            this.jobLogStatus(jobLogStatus == null ? null : jobLogStatus.toString());
            return this;
        }

        public final MembershipProtectedQueryResultConfiguration.Builder getDefaultResultConfiguration() {
            return this.defaultResultConfiguration != null ? this.defaultResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultResultConfiguration(MembershipProtectedQueryResultConfiguration.BuilderImpl defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration != null ? defaultResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        public final MembershipProtectedJobResultConfiguration.Builder getDefaultJobResultConfiguration() {
            return this.defaultJobResultConfiguration != null ? this.defaultJobResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultJobResultConfiguration(MembershipProtectedJobResultConfiguration.BuilderImpl defaultJobResultConfiguration) {
            this.defaultJobResultConfiguration = defaultJobResultConfiguration != null ? defaultJobResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration defaultJobResultConfiguration) {
            this.defaultJobResultConfiguration = defaultJobResultConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMembershipRequest build() {
            return new UpdateMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMembershipRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder queryLogStatus(String var1);

        public Builder queryLogStatus(MembershipQueryLogStatus var1);

        public Builder jobLogStatus(String var1);

        public Builder jobLogStatus(MembershipJobLogStatus var1);

        public Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration var1);

        default public Builder defaultResultConfiguration(Consumer<MembershipProtectedQueryResultConfiguration.Builder> defaultResultConfiguration) {
            return this.defaultResultConfiguration((MembershipProtectedQueryResultConfiguration)((MembershipProtectedQueryResultConfiguration.Builder)MembershipProtectedQueryResultConfiguration.builder().applyMutation(defaultResultConfiguration)).build());
        }

        public Builder defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration var1);

        default public Builder defaultJobResultConfiguration(Consumer<MembershipProtectedJobResultConfiguration.Builder> defaultJobResultConfiguration) {
            return this.defaultJobResultConfiguration((MembershipProtectedJobResultConfiguration)((MembershipProtectedJobResultConfiguration.Builder)MembershipProtectedJobResultConfiguration.builder().applyMutation(defaultJobResultConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

