/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatus;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusReason;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationStatusReasonListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateValidationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisTemplateValidationStatusDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisTemplateValidationStatusDetail> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AnalysisTemplateValidationStatusDetail.getter(AnalysisTemplateValidationStatusDetail::typeAsString)).setter(AnalysisTemplateValidationStatusDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AnalysisTemplateValidationStatusDetail.getter(AnalysisTemplateValidationStatusDetail::statusAsString)).setter(AnalysisTemplateValidationStatusDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<AnalysisTemplateValidationStatusReason>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reasons").getter(AnalysisTemplateValidationStatusDetail.getter(AnalysisTemplateValidationStatusDetail::reasons)).setter(AnalysisTemplateValidationStatusDetail.setter(Builder::reasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisTemplateValidationStatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD, REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisTemplateValidationStatusDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String status;
    private final List<AnalysisTemplateValidationStatusReason> reasons;

    private AnalysisTemplateValidationStatusDetail(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.reasons = builder.reasons;
    }

    public final AnalysisTemplateValidationType type() {
        return AnalysisTemplateValidationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AnalysisTemplateValidationStatus status() {
        return AnalysisTemplateValidationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<AnalysisTemplateValidationStatusReason> reasons() {
        return this.reasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTemplateValidationStatusDetail)) {
            return false;
        }
        AnalysisTemplateValidationStatusDetail other = (AnalysisTemplateValidationStatusDetail)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasons(), other.reasons());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisTemplateValidationStatusDetail").add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Reasons", this.hasReasons() ? this.reasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "reasons": {
                return Optional.ofNullable(clazz.cast(this.reasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("reasons", REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTemplateValidationStatusDetail, T> g) {
        return obj -> g.apply((AnalysisTemplateValidationStatusDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String status;
        private List<AnalysisTemplateValidationStatusReason> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTemplateValidationStatusDetail model) {
            this.type(model.type);
            this.status(model.status);
            this.reasons(model.reasons);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisTemplateValidationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalysisTemplateValidationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AnalysisTemplateValidationStatusReason.Builder> getReasons() {
            List<AnalysisTemplateValidationStatusReason.Builder> result = AnalysisTemplateValidationStatusReasonListCopier.copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<AnalysisTemplateValidationStatusReason.BuilderImpl> reasons) {
            this.reasons = AnalysisTemplateValidationStatusReasonListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<AnalysisTemplateValidationStatusReason> reasons) {
            this.reasons = AnalysisTemplateValidationStatusReasonListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(AnalysisTemplateValidationStatusReason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<AnalysisTemplateValidationStatusReason.Builder> ... reasons) {
            this.reasons(Stream.of(reasons).map(c -> (AnalysisTemplateValidationStatusReason)((AnalysisTemplateValidationStatusReason.Builder)AnalysisTemplateValidationStatusReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalysisTemplateValidationStatusDetail build() {
            return new AnalysisTemplateValidationStatusDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisTemplateValidationStatusDetail> {
        public Builder type(String var1);

        public Builder type(AnalysisTemplateValidationType var1);

        public Builder status(String var1);

        public Builder status(AnalysisTemplateValidationStatus var1);

        public Builder reasons(Collection<AnalysisTemplateValidationStatusReason> var1);

        public Builder reasons(AnalysisTemplateValidationStatusReason ... var1);

        public Builder reasons(Consumer<AnalysisTemplateValidationStatusReason.Builder> ... var1);
    }
}

