/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisType;
import software.amazon.awssdk.services.cleanrooms.model.SchemaConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.SchemaConfigurationListCopier;
import software.amazon.awssdk.services.cleanrooms.model.SchemaStatus;
import software.amazon.awssdk.services.cleanrooms.model.SchemaStatusReason;
import software.amazon.awssdk.services.cleanrooms.model.SchemaStatusReasonListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaStatusDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaStatusDetail> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SchemaStatusDetail.getter(SchemaStatusDetail::statusAsString)).setter(SchemaStatusDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<SchemaStatusReason>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reasons").getter(SchemaStatusDetail.getter(SchemaStatusDetail::reasons)).setter(SchemaStatusDetail.setter(Builder::reasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaStatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisRuleType").getter(SchemaStatusDetail.getter(SchemaStatusDetail::analysisRuleTypeAsString)).setter(SchemaStatusDetail.setter(Builder::analysisRuleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleType").build()}).build();
    private static final SdkField<List<String>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurations").getter(SchemaStatusDetail.getter(SchemaStatusDetail::configurationsAsStrings)).setter(SchemaStatusDetail.setter(Builder::configurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisType").getter(SchemaStatusDetail.getter(SchemaStatusDetail::analysisTypeAsString)).setter(SchemaStatusDetail.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASONS_FIELD, ANALYSIS_RULE_TYPE_FIELD, CONFIGURATIONS_FIELD, ANALYSIS_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaStatusDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<SchemaStatusReason> reasons;
    private final String analysisRuleType;
    private final List<String> configurations;
    private final String analysisType;

    private SchemaStatusDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.reasons = builder.reasons;
        this.analysisRuleType = builder.analysisRuleType;
        this.configurations = builder.configurations;
        this.analysisType = builder.analysisType;
    }

    public final SchemaStatus status() {
        return SchemaStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<SchemaStatusReason> reasons() {
        return this.reasons;
    }

    public final AnalysisRuleType analysisRuleType() {
        return AnalysisRuleType.fromValue(this.analysisRuleType);
    }

    public final String analysisRuleTypeAsString() {
        return this.analysisRuleType;
    }

    public final List<SchemaConfiguration> configurations() {
        return SchemaConfigurationListCopier.copyStringToEnum(this.configurations);
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<String> configurationsAsStrings() {
        return this.configurations;
    }

    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisRuleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaStatusDetail)) {
            return false;
        }
        SchemaStatusDetail other = (SchemaStatusDetail)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasons(), other.reasons()) && Objects.equals(this.analysisRuleTypeAsString(), other.analysisRuleTypeAsString()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurationsAsStrings(), other.configurationsAsStrings()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaStatusDetail").add("Status", (Object)this.statusAsString()).add("Reasons", this.hasReasons() ? this.reasons() : null).add("AnalysisRuleType", (Object)this.analysisRuleTypeAsString()).add("Configurations", this.hasConfigurations() ? this.configurationsAsStrings() : null).add("AnalysisType", (Object)this.analysisTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "reasons": {
                return Optional.ofNullable(clazz.cast(this.reasons()));
            }
            case "analysisRuleType": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypeAsString()));
            }
            case "configurations": {
                return Optional.ofNullable(clazz.cast(this.configurationsAsStrings()));
            }
            case "analysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("reasons", REASONS_FIELD);
        map.put("analysisRuleType", ANALYSIS_RULE_TYPE_FIELD);
        map.put("configurations", CONFIGURATIONS_FIELD);
        map.put("analysisType", ANALYSIS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaStatusDetail, T> g) {
        return obj -> g.apply((SchemaStatusDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<SchemaStatusReason> reasons = DefaultSdkAutoConstructList.getInstance();
        private String analysisRuleType;
        private List<String> configurations = DefaultSdkAutoConstructList.getInstance();
        private String analysisType;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaStatusDetail model) {
            this.status(model.status);
            this.reasons(model.reasons);
            this.analysisRuleType(model.analysisRuleType);
            this.configurationsWithStrings(model.configurations);
            this.analysisType(model.analysisType);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SchemaStatusReason.Builder> getReasons() {
            List<SchemaStatusReason.Builder> result = SchemaStatusReasonListCopier.copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<SchemaStatusReason.BuilderImpl> reasons) {
            this.reasons = SchemaStatusReasonListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<SchemaStatusReason> reasons) {
            this.reasons = SchemaStatusReasonListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(SchemaStatusReason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<SchemaStatusReason.Builder> ... reasons) {
            this.reasons(Stream.of(reasons).map(c -> (SchemaStatusReason)((SchemaStatusReason.Builder)SchemaStatusReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAnalysisRuleType() {
            return this.analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(AnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        public final Collection<String> getConfigurations() {
            if (this.configurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurations;
        }

        public final void setConfigurations(Collection<String> configurations) {
            this.configurations = SchemaConfigurationListCopier.copy(configurations);
        }

        @Override
        public final Builder configurationsWithStrings(Collection<String> configurations) {
            this.configurations = SchemaConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationsWithStrings(String ... configurations) {
            this.configurationsWithStrings(Arrays.asList(configurations));
            return this;
        }

        @Override
        public final Builder configurations(Collection<SchemaConfiguration> configurations) {
            this.configurations = SchemaConfigurationListCopier.copyEnumToString(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(SchemaConfiguration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public SchemaStatusDetail build() {
            return new SchemaStatusDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaStatusDetail> {
        public Builder status(String var1);

        public Builder status(SchemaStatus var1);

        public Builder reasons(Collection<SchemaStatusReason> var1);

        public Builder reasons(SchemaStatusReason ... var1);

        public Builder reasons(Consumer<SchemaStatusReason.Builder> ... var1);

        public Builder analysisRuleType(String var1);

        public Builder analysisRuleType(AnalysisRuleType var1);

        public Builder configurationsWithStrings(Collection<String> var1);

        public Builder configurationsWithStrings(String ... var1);

        public Builder configurations(Collection<SchemaConfiguration> var1);

        public Builder configurations(SchemaConfiguration ... var1);

        public Builder analysisType(String var1);

        public Builder analysisType(AnalysisType var1);
    }
}

