/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRule;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleError;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaAnalysisRuleErrorListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.SchemaAnalysisRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetSchemaAnalysisRuleResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, BatchGetSchemaAnalysisRuleResponse> {
    private static final SdkField<List<AnalysisRule>> ANALYSIS_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisRules").getter(BatchGetSchemaAnalysisRuleResponse.getter(BatchGetSchemaAnalysisRuleResponse::analysisRules)).setter(BatchGetSchemaAnalysisRuleResponse.setter(Builder::analysisRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetSchemaAnalysisRuleError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetSchemaAnalysisRuleResponse.getter(BatchGetSchemaAnalysisRuleResponse::errors)).setter(BatchGetSchemaAnalysisRuleResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetSchemaAnalysisRuleError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_RULES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetSchemaAnalysisRuleResponse.memberNameToFieldInitializer();
    private final List<AnalysisRule> analysisRules;
    private final List<BatchGetSchemaAnalysisRuleError> errors;

    private BatchGetSchemaAnalysisRuleResponse(BuilderImpl builder) {
        super(builder);
        this.analysisRules = builder.analysisRules;
        this.errors = builder.errors;
    }

    public final boolean hasAnalysisRules() {
        return this.analysisRules != null && !(this.analysisRules instanceof SdkAutoConstructList);
    }

    public final List<AnalysisRule> analysisRules() {
        return this.analysisRules;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetSchemaAnalysisRuleError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisRules() ? this.analysisRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaAnalysisRuleResponse)) {
            return false;
        }
        BatchGetSchemaAnalysisRuleResponse other = (BatchGetSchemaAnalysisRuleResponse)((Object)obj);
        return this.hasAnalysisRules() == other.hasAnalysisRules() && Objects.equals(this.analysisRules(), other.analysisRules()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetSchemaAnalysisRuleResponse").add("AnalysisRules", this.hasAnalysisRules() ? this.analysisRules() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analysisRules": {
                return Optional.ofNullable(clazz.cast(this.analysisRules()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("analysisRules", ANALYSIS_RULES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSchemaAnalysisRuleResponse, T> g) {
        return obj -> g.apply((BatchGetSchemaAnalysisRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<AnalysisRule> analysisRules = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetSchemaAnalysisRuleError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSchemaAnalysisRuleResponse model) {
            super(model);
            this.analysisRules(model.analysisRules);
            this.errors(model.errors);
        }

        public final List<AnalysisRule.Builder> getAnalysisRules() {
            List<AnalysisRule.Builder> result = SchemaAnalysisRuleListCopier.copyToBuilder(this.analysisRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisRules(Collection<AnalysisRule.BuilderImpl> analysisRules) {
            this.analysisRules = SchemaAnalysisRuleListCopier.copyFromBuilder(analysisRules);
        }

        @Override
        public final Builder analysisRules(Collection<AnalysisRule> analysisRules) {
            this.analysisRules = SchemaAnalysisRuleListCopier.copy(analysisRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRules(AnalysisRule ... analysisRules) {
            this.analysisRules(Arrays.asList(analysisRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRules(Consumer<AnalysisRule.Builder> ... analysisRules) {
            this.analysisRules(Stream.of(analysisRules).map(c -> (AnalysisRule)((AnalysisRule.Builder)AnalysisRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetSchemaAnalysisRuleError.Builder> getErrors() {
            List<BatchGetSchemaAnalysisRuleError.Builder> result = BatchGetSchemaAnalysisRuleErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetSchemaAnalysisRuleError.BuilderImpl> errors) {
            this.errors = BatchGetSchemaAnalysisRuleErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetSchemaAnalysisRuleError> errors) {
            this.errors = BatchGetSchemaAnalysisRuleErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetSchemaAnalysisRuleError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetSchemaAnalysisRuleError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetSchemaAnalysisRuleError)((BatchGetSchemaAnalysisRuleError.Builder)BatchGetSchemaAnalysisRuleError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSchemaAnalysisRuleResponse build() {
            return new BatchGetSchemaAnalysisRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetSchemaAnalysisRuleResponse> {
        public Builder analysisRules(Collection<AnalysisRule> var1);

        public Builder analysisRules(AnalysisRule ... var1);

        public Builder analysisRules(Consumer<AnalysisRule.Builder> ... var1);

        public Builder errors(Collection<BatchGetSchemaAnalysisRuleError> var1);

        public Builder errors(BatchGetSchemaAnalysisRuleError ... var1);

        public Builder errors(Consumer<BatchGetSchemaAnalysisRuleError.Builder> ... var1);
    }
}

