/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetSummary;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrivacyBudgetsResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListPrivacyBudgetsResponse> {
    private static final SdkField<List<PrivacyBudgetSummary>> PRIVACY_BUDGET_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("privacyBudgetSummaries").getter(ListPrivacyBudgetsResponse.getter(ListPrivacyBudgetsResponse::privacyBudgetSummaries)).setter(ListPrivacyBudgetsResponse.setter(Builder::privacyBudgetSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivacyBudgetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPrivacyBudgetsResponse.getter(ListPrivacyBudgetsResponse::nextToken)).setter(ListPrivacyBudgetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVACY_BUDGET_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPrivacyBudgetsResponse.memberNameToFieldInitializer();
    private final List<PrivacyBudgetSummary> privacyBudgetSummaries;
    private final String nextToken;

    private ListPrivacyBudgetsResponse(BuilderImpl builder) {
        super(builder);
        this.privacyBudgetSummaries = builder.privacyBudgetSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPrivacyBudgetSummaries() {
        return this.privacyBudgetSummaries != null && !(this.privacyBudgetSummaries instanceof SdkAutoConstructList);
    }

    public final List<PrivacyBudgetSummary> privacyBudgetSummaries() {
        return this.privacyBudgetSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivacyBudgetSummaries() ? this.privacyBudgetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrivacyBudgetsResponse)) {
            return false;
        }
        ListPrivacyBudgetsResponse other = (ListPrivacyBudgetsResponse)((Object)obj);
        return this.hasPrivacyBudgetSummaries() == other.hasPrivacyBudgetSummaries() && Objects.equals(this.privacyBudgetSummaries(), other.privacyBudgetSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPrivacyBudgetsResponse").add("PrivacyBudgetSummaries", this.hasPrivacyBudgetSummaries() ? this.privacyBudgetSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "privacyBudgetSummaries": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("privacyBudgetSummaries", PRIVACY_BUDGET_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPrivacyBudgetsResponse, T> g) {
        return obj -> g.apply((ListPrivacyBudgetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<PrivacyBudgetSummary> privacyBudgetSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrivacyBudgetsResponse model) {
            super(model);
            this.privacyBudgetSummaries(model.privacyBudgetSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<PrivacyBudgetSummary.Builder> getPrivacyBudgetSummaries() {
            List<PrivacyBudgetSummary.Builder> result = PrivacyBudgetSummaryListCopier.copyToBuilder(this.privacyBudgetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivacyBudgetSummaries(Collection<PrivacyBudgetSummary.BuilderImpl> privacyBudgetSummaries) {
            this.privacyBudgetSummaries = PrivacyBudgetSummaryListCopier.copyFromBuilder(privacyBudgetSummaries);
        }

        @Override
        public final Builder privacyBudgetSummaries(Collection<PrivacyBudgetSummary> privacyBudgetSummaries) {
            this.privacyBudgetSummaries = PrivacyBudgetSummaryListCopier.copy(privacyBudgetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privacyBudgetSummaries(PrivacyBudgetSummary ... privacyBudgetSummaries) {
            this.privacyBudgetSummaries(Arrays.asList(privacyBudgetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privacyBudgetSummaries(Consumer<PrivacyBudgetSummary.Builder> ... privacyBudgetSummaries) {
            this.privacyBudgetSummaries(Stream.of(privacyBudgetSummaries).map(c -> (PrivacyBudgetSummary)((PrivacyBudgetSummary.Builder)PrivacyBudgetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPrivacyBudgetsResponse build() {
            return new ListPrivacyBudgetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrivacyBudgetsResponse> {
        public Builder privacyBudgetSummaries(Collection<PrivacyBudgetSummary> var1);

        public Builder privacyBudgetSummaries(PrivacyBudgetSummary ... var1);

        public Builder privacyBudgetSummaries(Consumer<PrivacyBudgetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

