/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleIdMappingTableJoinColumnsListCopier;
import software.amazon.awssdk.services.cleanrooms.model.QueryConstraint;
import software.amazon.awssdk.services.cleanrooms.model.QueryConstraintListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisRuleIdMappingTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisRuleIdMappingTable> {
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("joinColumns").getter(AnalysisRuleIdMappingTable.getter(AnalysisRuleIdMappingTable::joinColumns)).setter(AnalysisRuleIdMappingTable.setter(Builder::joinColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<QueryConstraint>> QUERY_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queryConstraints").getter(AnalysisRuleIdMappingTable.getter(AnalysisRuleIdMappingTable::queryConstraints)).setter(AnalysisRuleIdMappingTable.setter(Builder::queryConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DIMENSION_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dimensionColumns").getter(AnalysisRuleIdMappingTable.getter(AnalysisRuleIdMappingTable::dimensionColumns)).setter(AnalysisRuleIdMappingTable.setter(Builder::dimensionColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_COLUMNS_FIELD, QUERY_CONSTRAINTS_FIELD, DIMENSION_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisRuleIdMappingTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> joinColumns;
    private final List<QueryConstraint> queryConstraints;
    private final List<String> dimensionColumns;

    private AnalysisRuleIdMappingTable(BuilderImpl builder) {
        this.joinColumns = builder.joinColumns;
        this.queryConstraints = builder.queryConstraints;
        this.dimensionColumns = builder.dimensionColumns;
    }

    public final boolean hasJoinColumns() {
        return this.joinColumns != null && !(this.joinColumns instanceof SdkAutoConstructList);
    }

    public final List<String> joinColumns() {
        return this.joinColumns;
    }

    public final boolean hasQueryConstraints() {
        return this.queryConstraints != null && !(this.queryConstraints instanceof SdkAutoConstructList);
    }

    public final List<QueryConstraint> queryConstraints() {
        return this.queryConstraints;
    }

    public final boolean hasDimensionColumns() {
        return this.dimensionColumns != null && !(this.dimensionColumns instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionColumns() {
        return this.dimensionColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinColumns() ? this.joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryConstraints() ? this.queryConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionColumns() ? this.dimensionColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleIdMappingTable)) {
            return false;
        }
        AnalysisRuleIdMappingTable other = (AnalysisRuleIdMappingTable)obj;
        return this.hasJoinColumns() == other.hasJoinColumns() && Objects.equals(this.joinColumns(), other.joinColumns()) && this.hasQueryConstraints() == other.hasQueryConstraints() && Objects.equals(this.queryConstraints(), other.queryConstraints()) && this.hasDimensionColumns() == other.hasDimensionColumns() && Objects.equals(this.dimensionColumns(), other.dimensionColumns());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisRuleIdMappingTable").add("JoinColumns", this.hasJoinColumns() ? this.joinColumns() : null).add("QueryConstraints", this.hasQueryConstraints() ? this.queryConstraints() : null).add("DimensionColumns", this.hasDimensionColumns() ? this.dimensionColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "joinColumns": {
                return Optional.ofNullable(clazz.cast(this.joinColumns()));
            }
            case "queryConstraints": {
                return Optional.ofNullable(clazz.cast(this.queryConstraints()));
            }
            case "dimensionColumns": {
                return Optional.ofNullable(clazz.cast(this.dimensionColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("joinColumns", JOIN_COLUMNS_FIELD);
        map.put("queryConstraints", QUERY_CONSTRAINTS_FIELD);
        map.put("dimensionColumns", DIMENSION_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleIdMappingTable, T> g) {
        return obj -> g.apply((AnalysisRuleIdMappingTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();
        private List<QueryConstraint> queryConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<String> dimensionColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleIdMappingTable model) {
            this.joinColumns(model.joinColumns);
            this.queryConstraints(model.queryConstraints);
            this.dimensionColumns(model.dimensionColumns);
        }

        public final Collection<String> getJoinColumns() {
            if (this.joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleIdMappingTableJoinColumnsListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleIdMappingTableJoinColumnsListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String ... joinColumns) {
            this.joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final List<QueryConstraint.Builder> getQueryConstraints() {
            List<QueryConstraint.Builder> result = QueryConstraintListCopier.copyToBuilder(this.queryConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryConstraints(Collection<QueryConstraint.BuilderImpl> queryConstraints) {
            this.queryConstraints = QueryConstraintListCopier.copyFromBuilder(queryConstraints);
        }

        @Override
        public final Builder queryConstraints(Collection<QueryConstraint> queryConstraints) {
            this.queryConstraints = QueryConstraintListCopier.copy(queryConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryConstraints(QueryConstraint ... queryConstraints) {
            this.queryConstraints(Arrays.asList(queryConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryConstraints(Consumer<QueryConstraint.Builder> ... queryConstraints) {
            this.queryConstraints(Stream.of(queryConstraints).map(c -> (QueryConstraint)((QueryConstraint.Builder)QueryConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDimensionColumns() {
            if (this.dimensionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionColumns;
        }

        public final void setDimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
        }

        @Override
        public final Builder dimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionColumns(String ... dimensionColumns) {
            this.dimensionColumns(Arrays.asList(dimensionColumns));
            return this;
        }

        public AnalysisRuleIdMappingTable build() {
            return new AnalysisRuleIdMappingTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisRuleIdMappingTable> {
        public Builder joinColumns(Collection<String> var1);

        public Builder joinColumns(String ... var1);

        public Builder queryConstraints(Collection<QueryConstraint> var1);

        public Builder queryConstraints(QueryConstraint ... var1);

        public Builder queryConstraints(Consumer<QueryConstraint.Builder> ... var1);

        public Builder dimensionColumns(Collection<String> var1);

        public Builder dimensionColumns(String ... var1);
    }
}

