/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedJobsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedJobsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSummary;

public class ListProtectedJobsPublisher
implements SdkPublisher<ListProtectedJobsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListProtectedJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtectedJobsPublisher(CleanRoomsAsyncClient client, ListProtectedJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtectedJobsPublisher(CleanRoomsAsyncClient client, ListProtectedJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtectedJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtectedJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProtectedJobSummary> protectedJobs() {
        Function<ListProtectedJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protectedJobs() != null) {
                return response.protectedJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProtectedJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProtectedJobsResponseFetcher
    implements AsyncPageFetcher<ListProtectedJobsResponse> {
        private ListProtectedJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtectedJobsResponse> nextPage(ListProtectedJobsResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedJobsPublisher.this.client.listProtectedJobs(ListProtectedJobsPublisher.this.firstRequest);
            }
            return ListProtectedJobsPublisher.this.client.listProtectedJobs((ListProtectedJobsRequest)((Object)ListProtectedJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

