/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRulePolicy;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationAnalysisRulePolicy;
import software.amazon.awssdk.services.cleanrooms.model.ConsolidatedPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisRule> {
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(AnalysisRule.getter(AnalysisRule::collaborationId)).setter(AnalysisRule.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AnalysisRule.getter(AnalysisRule::typeAsString)).setter(AnalysisRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AnalysisRule.getter(AnalysisRule::name)).setter(AnalysisRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(AnalysisRule.getter(AnalysisRule::createTime)).setter(AnalysisRule.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(AnalysisRule.getter(AnalysisRule::updateTime)).setter(AnalysisRule.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<AnalysisRulePolicy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policy").getter(AnalysisRule.getter(AnalysisRule::policy)).setter(AnalysisRule.setter(Builder::policy)).constructor(AnalysisRulePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<ConfiguredTableAssociationAnalysisRulePolicy> COLLABORATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("collaborationPolicy").getter(AnalysisRule.getter(AnalysisRule::collaborationPolicy)).setter(AnalysisRule.setter(Builder::collaborationPolicy)).constructor(ConfiguredTableAssociationAnalysisRulePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationPolicy").build()}).build();
    private static final SdkField<ConsolidatedPolicy> CONSOLIDATED_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("consolidatedPolicy").getter(AnalysisRule.getter(AnalysisRule::consolidatedPolicy)).setter(AnalysisRule.setter(Builder::consolidatedPolicy)).constructor(ConsolidatedPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidatedPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_ID_FIELD, TYPE_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, POLICY_FIELD, COLLABORATION_POLICY_FIELD, CONSOLIDATED_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collaborationId;
    private final String type;
    private final String name;
    private final Instant createTime;
    private final Instant updateTime;
    private final AnalysisRulePolicy policy;
    private final ConfiguredTableAssociationAnalysisRulePolicy collaborationPolicy;
    private final ConsolidatedPolicy consolidatedPolicy;

    private AnalysisRule(BuilderImpl builder) {
        this.collaborationId = builder.collaborationId;
        this.type = builder.type;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.policy = builder.policy;
        this.collaborationPolicy = builder.collaborationPolicy;
        this.consolidatedPolicy = builder.consolidatedPolicy;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final AnalysisRuleType type() {
        return AnalysisRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final AnalysisRulePolicy policy() {
        return this.policy;
    }

    public final ConfiguredTableAssociationAnalysisRulePolicy collaborationPolicy() {
        return this.collaborationPolicy;
    }

    public final ConsolidatedPolicy consolidatedPolicy() {
        return this.consolidatedPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.consolidatedPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRule)) {
            return false;
        }
        AnalysisRule other = (AnalysisRule)obj;
        return Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.collaborationPolicy(), other.collaborationPolicy()) && Objects.equals(this.consolidatedPolicy(), other.consolidatedPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisRule").add("CollaborationId", (Object)this.collaborationId()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Policy", (Object)this.policy()).add("CollaborationPolicy", (Object)this.collaborationPolicy()).add("ConsolidatedPolicy", (Object)this.consolidatedPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "collaborationPolicy": {
                return Optional.ofNullable(clazz.cast(this.collaborationPolicy()));
            }
            case "consolidatedPolicy": {
                return Optional.ofNullable(clazz.cast(this.consolidatedPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("collaborationPolicy", COLLABORATION_POLICY_FIELD);
        map.put("consolidatedPolicy", CONSOLIDATED_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRule, T> g) {
        return obj -> g.apply((AnalysisRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collaborationId;
        private String type;
        private String name;
        private Instant createTime;
        private Instant updateTime;
        private AnalysisRulePolicy policy;
        private ConfiguredTableAssociationAnalysisRulePolicy collaborationPolicy;
        private ConsolidatedPolicy consolidatedPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRule model) {
            this.collaborationId(model.collaborationId);
            this.type(model.type);
            this.name(model.name);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.policy(model.policy);
            this.collaborationPolicy(model.collaborationPolicy);
            this.consolidatedPolicy(model.consolidatedPolicy);
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final AnalysisRulePolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(AnalysisRulePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(AnalysisRulePolicy policy) {
            this.policy = policy;
            return this;
        }

        public final ConfiguredTableAssociationAnalysisRulePolicy.Builder getCollaborationPolicy() {
            return this.collaborationPolicy != null ? this.collaborationPolicy.toBuilder() : null;
        }

        public final void setCollaborationPolicy(ConfiguredTableAssociationAnalysisRulePolicy.BuilderImpl collaborationPolicy) {
            this.collaborationPolicy = collaborationPolicy != null ? collaborationPolicy.build() : null;
        }

        @Override
        public final Builder collaborationPolicy(ConfiguredTableAssociationAnalysisRulePolicy collaborationPolicy) {
            this.collaborationPolicy = collaborationPolicy;
            return this;
        }

        public final ConsolidatedPolicy.Builder getConsolidatedPolicy() {
            return this.consolidatedPolicy != null ? this.consolidatedPolicy.toBuilder() : null;
        }

        public final void setConsolidatedPolicy(ConsolidatedPolicy.BuilderImpl consolidatedPolicy) {
            this.consolidatedPolicy = consolidatedPolicy != null ? consolidatedPolicy.build() : null;
        }

        @Override
        public final Builder consolidatedPolicy(ConsolidatedPolicy consolidatedPolicy) {
            this.consolidatedPolicy = consolidatedPolicy;
            return this;
        }

        public AnalysisRule build() {
            return new AnalysisRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisRule> {
        public Builder collaborationId(String var1);

        public Builder type(String var1);

        public Builder type(AnalysisRuleType var1);

        public Builder name(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder policy(AnalysisRulePolicy var1);

        default public Builder policy(Consumer<AnalysisRulePolicy.Builder> policy) {
            return this.policy((AnalysisRulePolicy)((AnalysisRulePolicy.Builder)AnalysisRulePolicy.builder().applyMutation(policy)).build());
        }

        public Builder collaborationPolicy(ConfiguredTableAssociationAnalysisRulePolicy var1);

        default public Builder collaborationPolicy(Consumer<ConfiguredTableAssociationAnalysisRulePolicy.Builder> collaborationPolicy) {
            return this.collaborationPolicy((ConfiguredTableAssociationAnalysisRulePolicy)((ConfiguredTableAssociationAnalysisRulePolicy.Builder)ConfiguredTableAssociationAnalysisRulePolicy.builder().applyMutation(collaborationPolicy)).build());
        }

        public Builder consolidatedPolicy(ConsolidatedPolicy var1);

        default public Builder consolidatedPolicy(Consumer<ConsolidatedPolicy.Builder> consolidatedPolicy) {
            return this.consolidatedPolicy((ConsolidatedPolicy)((ConsolidatedPolicy.Builder)ConsolidatedPolicy.builder().applyMutation(consolidatedPolicy)).build());
        }
    }
}

