/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetTemplatesResponse;

public class ListCollaborationPrivacyBudgetTemplatesIterable
implements SdkIterable<ListCollaborationPrivacyBudgetTemplatesResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationPrivacyBudgetTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationPrivacyBudgetTemplatesIterable(CleanRoomsClient client, ListCollaborationPrivacyBudgetTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationPrivacyBudgetTemplatesResponseFetcher();
    }

    public Iterator<ListCollaborationPrivacyBudgetTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationPrivacyBudgetTemplateSummary> collaborationPrivacyBudgetTemplateSummaries() {
        Function<ListCollaborationPrivacyBudgetTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationPrivacyBudgetTemplateSummaries() != null) {
                return response.collaborationPrivacyBudgetTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationPrivacyBudgetTemplatesResponseFetcher
    implements SyncPageFetcher<ListCollaborationPrivacyBudgetTemplatesResponse> {
        private ListCollaborationPrivacyBudgetTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationPrivacyBudgetTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationPrivacyBudgetTemplatesResponse nextPage(ListCollaborationPrivacyBudgetTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationPrivacyBudgetTemplatesIterable.this.client.listCollaborationPrivacyBudgetTemplates(ListCollaborationPrivacyBudgetTemplatesIterable.this.firstRequest);
            }
            return ListCollaborationPrivacyBudgetTemplatesIterable.this.client.listCollaborationPrivacyBudgetTemplates((ListCollaborationPrivacyBudgetTemplatesRequest)((Object)ListCollaborationPrivacyBudgetTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

