/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredAudienceModelAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredAudienceModelAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredAudienceModelAssociationsResponse;

public class ListConfiguredAudienceModelAssociationsIterable
implements SdkIterable<ListConfiguredAudienceModelAssociationsResponse> {
    private final CleanRoomsClient client;
    private final ListConfiguredAudienceModelAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfiguredAudienceModelAssociationsIterable(CleanRoomsClient client, ListConfiguredAudienceModelAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfiguredAudienceModelAssociationsResponseFetcher();
    }

    public Iterator<ListConfiguredAudienceModelAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries() {
        Function<ListConfiguredAudienceModelAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredAudienceModelAssociationSummaries() != null) {
                return response.configuredAudienceModelAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfiguredAudienceModelAssociationsResponseFetcher
    implements SyncPageFetcher<ListConfiguredAudienceModelAssociationsResponse> {
        private ListConfiguredAudienceModelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredAudienceModelAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfiguredAudienceModelAssociationsResponse nextPage(ListConfiguredAudienceModelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredAudienceModelAssociationsIterable.this.client.listConfiguredAudienceModelAssociations(ListConfiguredAudienceModelAssociationsIterable.this.firstRequest);
            }
            return ListConfiguredAudienceModelAssociationsIterable.this.client.listConfiguredAudienceModelAssociations((ListConfiguredAudienceModelAssociationsRequest)((Object)ListConfiguredAudienceModelAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

