/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateAutoRefresh;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateParametersInput;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetType;
import software.amazon.awssdk.services.cleanrooms.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePrivacyBudgetTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreatePrivacyBudgetTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreatePrivacyBudgetTemplateRequest.getter(CreatePrivacyBudgetTemplateRequest::membershipIdentifier)).setter(CreatePrivacyBudgetTemplateRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> AUTO_REFRESH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoRefresh").getter(CreatePrivacyBudgetTemplateRequest.getter(CreatePrivacyBudgetTemplateRequest::autoRefreshAsString)).setter(CreatePrivacyBudgetTemplateRequest.setter(Builder::autoRefresh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRefresh").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetType").getter(CreatePrivacyBudgetTemplateRequest.getter(CreatePrivacyBudgetTemplateRequest::privacyBudgetTypeAsString)).setter(CreatePrivacyBudgetTemplateRequest.setter(Builder::privacyBudgetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetType").build()}).build();
    private static final SdkField<PrivacyBudgetTemplateParametersInput> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameters").getter(CreatePrivacyBudgetTemplateRequest.getter(CreatePrivacyBudgetTemplateRequest::parameters)).setter(CreatePrivacyBudgetTemplateRequest.setter(Builder::parameters)).constructor(PrivacyBudgetTemplateParametersInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreatePrivacyBudgetTemplateRequest.getter(CreatePrivacyBudgetTemplateRequest::tags)).setter(CreatePrivacyBudgetTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, AUTO_REFRESH_FIELD, PRIVACY_BUDGET_TYPE_FIELD, PARAMETERS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePrivacyBudgetTemplateRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String autoRefresh;
    private final String privacyBudgetType;
    private final PrivacyBudgetTemplateParametersInput parameters;
    private final Map<String, String> tags;

    private CreatePrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.autoRefresh = builder.autoRefresh;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final PrivacyBudgetTemplateAutoRefresh autoRefresh() {
        return PrivacyBudgetTemplateAutoRefresh.fromValue(this.autoRefresh);
    }

    public final String autoRefreshAsString() {
        return this.autoRefresh;
    }

    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(this.privacyBudgetType);
    }

    public final String privacyBudgetTypeAsString() {
        return this.privacyBudgetType;
    }

    public final PrivacyBudgetTemplateParametersInput parameters() {
        return this.parameters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRefreshAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivacyBudgetTemplateRequest)) {
            return false;
        }
        CreatePrivacyBudgetTemplateRequest other = (CreatePrivacyBudgetTemplateRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.autoRefreshAsString(), other.autoRefreshAsString()) && Objects.equals(this.privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString()) && Objects.equals(this.parameters(), other.parameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePrivacyBudgetTemplateRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("AutoRefresh", (Object)this.autoRefreshAsString()).add("PrivacyBudgetType", (Object)this.privacyBudgetTypeAsString()).add("Parameters", (Object)this.parameters()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "autoRefresh": {
                return Optional.ofNullable(clazz.cast(this.autoRefreshAsString()));
            }
            case "privacyBudgetType": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTypeAsString()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("autoRefresh", AUTO_REFRESH_FIELD);
        map.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((CreatePrivacyBudgetTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String autoRefresh;
        private String privacyBudgetType;
        private PrivacyBudgetTemplateParametersInput parameters;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivacyBudgetTemplateRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.autoRefresh(model.autoRefresh);
            this.privacyBudgetType(model.privacyBudgetType);
            this.parameters(model.parameters);
            this.tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getAutoRefresh() {
            return this.autoRefresh;
        }

        public final void setAutoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
        }

        @Override
        public final Builder autoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Override
        public final Builder autoRefresh(PrivacyBudgetTemplateAutoRefresh autoRefresh) {
            this.autoRefresh(autoRefresh == null ? null : autoRefresh.toString());
            return this;
        }

        public final String getPrivacyBudgetType() {
            return this.privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final PrivacyBudgetTemplateParametersInput.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(PrivacyBudgetTemplateParametersInput.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(PrivacyBudgetTemplateParametersInput parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivacyBudgetTemplateRequest build() {
            return new CreatePrivacyBudgetTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePrivacyBudgetTemplateRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder autoRefresh(String var1);

        public Builder autoRefresh(PrivacyBudgetTemplateAutoRefresh var1);

        public Builder privacyBudgetType(String var1);

        public Builder privacyBudgetType(PrivacyBudgetType var1);

        public Builder parameters(PrivacyBudgetTemplateParametersInput var1);

        default public Builder parameters(Consumer<PrivacyBudgetTemplateParametersInput.Builder> parameters) {
            return this.parameters((PrivacyBudgetTemplateParametersInput)((PrivacyBudgetTemplateParametersInput.Builder)PrivacyBudgetTemplateParametersInput.builder().applyMutation(parameters)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

