/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationAnalysisRulePolicy;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationAnalysisRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTableAssociationAnalysisRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRule> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::membershipIdentifier)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableAssociationId").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::configuredTableAssociationId)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::configuredTableAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableAssociationId").build()}).build();
    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableAssociationArn").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::configuredTableAssociationArn)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::configuredTableAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableAssociationArn").build()}).build();
    private static final SdkField<ConfiguredTableAssociationAnalysisRulePolicy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policy").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::policy)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::policy)).constructor(ConfiguredTableAssociationAnalysisRulePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::typeAsString)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::createTime)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredTableAssociationAnalysisRule.getter(ConfiguredTableAssociationAnalysisRule::updateTime)).setter(ConfiguredTableAssociationAnalysisRule.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, CONFIGURED_TABLE_ASSOCIATION_ID_FIELD, CONFIGURED_TABLE_ASSOCIATION_ARN_FIELD, POLICY_FIELD, TYPE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfiguredTableAssociationAnalysisRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String membershipIdentifier;
    private final String configuredTableAssociationId;
    private final String configuredTableAssociationArn;
    private final ConfiguredTableAssociationAnalysisRulePolicy policy;
    private final String type;
    private final Instant createTime;
    private final Instant updateTime;

    private ConfiguredTableAssociationAnalysisRule(BuilderImpl builder) {
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredTableAssociationId = builder.configuredTableAssociationId;
        this.configuredTableAssociationArn = builder.configuredTableAssociationArn;
        this.policy = builder.policy;
        this.type = builder.type;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String configuredTableAssociationId() {
        return this.configuredTableAssociationId;
    }

    public final String configuredTableAssociationArn() {
        return this.configuredTableAssociationArn;
    }

    public final ConfiguredTableAssociationAnalysisRulePolicy policy() {
        return this.policy;
    }

    public final ConfiguredTableAssociationAnalysisRuleType type() {
        return ConfiguredTableAssociationAnalysisRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociationAnalysisRule)) {
            return false;
        }
        ConfiguredTableAssociationAnalysisRule other = (ConfiguredTableAssociationAnalysisRule)obj;
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.configuredTableAssociationId(), other.configuredTableAssociationId()) && Objects.equals(this.configuredTableAssociationArn(), other.configuredTableAssociationArn()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTableAssociationAnalysisRule").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("ConfiguredTableAssociationId", (Object)this.configuredTableAssociationId()).add("ConfiguredTableAssociationArn", (Object)this.configuredTableAssociationArn()).add("Policy", (Object)this.policy()).add("Type", (Object)this.typeAsString()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "configuredTableAssociationId": {
                return Optional.ofNullable(clazz.cast(this.configuredTableAssociationId()));
            }
            case "configuredTableAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.configuredTableAssociationArn()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("configuredTableAssociationId", CONFIGURED_TABLE_ASSOCIATION_ID_FIELD);
        map.put("configuredTableAssociationArn", CONFIGURED_TABLE_ASSOCIATION_ARN_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociationAnalysisRule, T> g) {
        return obj -> g.apply((ConfiguredTableAssociationAnalysisRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String configuredTableAssociationId;
        private String configuredTableAssociationArn;
        private ConfiguredTableAssociationAnalysisRulePolicy policy;
        private String type;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociationAnalysisRule model) {
            this.membershipIdentifier(model.membershipIdentifier);
            this.configuredTableAssociationId(model.configuredTableAssociationId);
            this.configuredTableAssociationArn(model.configuredTableAssociationArn);
            this.policy(model.policy);
            this.type(model.type);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredTableAssociationId() {
            return this.configuredTableAssociationId;
        }

        public final void setConfiguredTableAssociationId(String configuredTableAssociationId) {
            this.configuredTableAssociationId = configuredTableAssociationId;
        }

        @Override
        public final Builder configuredTableAssociationId(String configuredTableAssociationId) {
            this.configuredTableAssociationId = configuredTableAssociationId;
            return this;
        }

        public final String getConfiguredTableAssociationArn() {
            return this.configuredTableAssociationArn;
        }

        public final void setConfiguredTableAssociationArn(String configuredTableAssociationArn) {
            this.configuredTableAssociationArn = configuredTableAssociationArn;
        }

        @Override
        public final Builder configuredTableAssociationArn(String configuredTableAssociationArn) {
            this.configuredTableAssociationArn = configuredTableAssociationArn;
            return this;
        }

        public final ConfiguredTableAssociationAnalysisRulePolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(ConfiguredTableAssociationAnalysisRulePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ConfiguredTableAssociationAnalysisRulePolicy policy) {
            this.policy = policy;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConfiguredTableAssociationAnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ConfiguredTableAssociationAnalysisRule build() {
            return new ConfiguredTableAssociationAnalysisRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRule> {
        public Builder membershipIdentifier(String var1);

        public Builder configuredTableAssociationId(String var1);

        public Builder configuredTableAssociationArn(String var1);

        public Builder policy(ConfiguredTableAssociationAnalysisRulePolicy var1);

        default public Builder policy(Consumer<ConfiguredTableAssociationAnalysisRulePolicy.Builder> policy) {
            return this.policy((ConfiguredTableAssociationAnalysisRulePolicy)((ConfiguredTableAssociationAnalysisRulePolicy.Builder)ConfiguredTableAssociationAnalysisRulePolicy.builder().applyMutation(policy)).build());
        }

        public Builder type(String var1);

        public Builder type(ConfiguredTableAssociationAnalysisRuleType var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

