/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRulePolicy;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfiguredTableAnalysisRuleRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateConfiguredTableAnalysisRuleRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableIdentifier").getter(CreateConfiguredTableAnalysisRuleRequest.getter(CreateConfiguredTableAnalysisRuleRequest::configuredTableIdentifier)).setter(CreateConfiguredTableAnalysisRuleRequest.setter(Builder::configuredTableIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableIdentifier").build()}).build();
    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisRuleType").getter(CreateConfiguredTableAnalysisRuleRequest.getter(CreateConfiguredTableAnalysisRuleRequest::analysisRuleTypeAsString)).setter(CreateConfiguredTableAnalysisRuleRequest.setter(Builder::analysisRuleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleType").build()}).build();
    private static final SdkField<ConfiguredTableAnalysisRulePolicy> ANALYSIS_RULE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("analysisRulePolicy").getter(CreateConfiguredTableAnalysisRuleRequest.getter(CreateConfiguredTableAnalysisRuleRequest::analysisRulePolicy)).setter(CreateConfiguredTableAnalysisRuleRequest.setter(Builder::analysisRulePolicy)).constructor(ConfiguredTableAnalysisRulePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRulePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_IDENTIFIER_FIELD, ANALYSIS_RULE_TYPE_FIELD, ANALYSIS_RULE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConfiguredTableAnalysisRuleRequest.memberNameToFieldInitializer();
    private final String configuredTableIdentifier;
    private final String analysisRuleType;
    private final ConfiguredTableAnalysisRulePolicy analysisRulePolicy;

    private CreateConfiguredTableAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableIdentifier = builder.configuredTableIdentifier;
        this.analysisRuleType = builder.analysisRuleType;
        this.analysisRulePolicy = builder.analysisRulePolicy;
    }

    public final String configuredTableIdentifier() {
        return this.configuredTableIdentifier;
    }

    public final ConfiguredTableAnalysisRuleType analysisRuleType() {
        return ConfiguredTableAnalysisRuleType.fromValue(this.analysisRuleType);
    }

    public final String analysisRuleTypeAsString() {
        return this.analysisRuleType;
    }

    public final ConfiguredTableAnalysisRulePolicy analysisRulePolicy() {
        return this.analysisRulePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisRuleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisRulePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredTableAnalysisRuleRequest)) {
            return false;
        }
        CreateConfiguredTableAnalysisRuleRequest other = (CreateConfiguredTableAnalysisRuleRequest)((Object)obj);
        return Objects.equals(this.configuredTableIdentifier(), other.configuredTableIdentifier()) && Objects.equals(this.analysisRuleTypeAsString(), other.analysisRuleTypeAsString()) && Objects.equals(this.analysisRulePolicy(), other.analysisRulePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfiguredTableAnalysisRuleRequest").add("ConfiguredTableIdentifier", (Object)this.configuredTableIdentifier()).add("AnalysisRuleType", (Object)this.analysisRuleTypeAsString()).add("AnalysisRulePolicy", (Object)this.analysisRulePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredTableIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configuredTableIdentifier()));
            }
            case "analysisRuleType": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypeAsString()));
            }
            case "analysisRulePolicy": {
                return Optional.ofNullable(clazz.cast(this.analysisRulePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuredTableIdentifier", CONFIGURED_TABLE_IDENTIFIER_FIELD);
        map.put("analysisRuleType", ANALYSIS_RULE_TYPE_FIELD);
        map.put("analysisRulePolicy", ANALYSIS_RULE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredTableAnalysisRuleRequest, T> g) {
        return obj -> g.apply((CreateConfiguredTableAnalysisRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String configuredTableIdentifier;
        private String analysisRuleType;
        private ConfiguredTableAnalysisRulePolicy analysisRulePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredTableAnalysisRuleRequest model) {
            super(model);
            this.configuredTableIdentifier(model.configuredTableIdentifier);
            this.analysisRuleType(model.analysisRuleType);
            this.analysisRulePolicy(model.analysisRulePolicy);
        }

        public final String getConfiguredTableIdentifier() {
            return this.configuredTableIdentifier;
        }

        public final void setConfiguredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
        }

        @Override
        public final Builder configuredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        public final String getAnalysisRuleType() {
            return this.analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(ConfiguredTableAnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        public final ConfiguredTableAnalysisRulePolicy.Builder getAnalysisRulePolicy() {
            return this.analysisRulePolicy != null ? this.analysisRulePolicy.toBuilder() : null;
        }

        public final void setAnalysisRulePolicy(ConfiguredTableAnalysisRulePolicy.BuilderImpl analysisRulePolicy) {
            this.analysisRulePolicy = analysisRulePolicy != null ? analysisRulePolicy.build() : null;
        }

        @Override
        public final Builder analysisRulePolicy(ConfiguredTableAnalysisRulePolicy analysisRulePolicy) {
            this.analysisRulePolicy = analysisRulePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredTableAnalysisRuleRequest build() {
            return new CreateConfiguredTableAnalysisRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfiguredTableAnalysisRuleRequest> {
        public Builder configuredTableIdentifier(String var1);

        public Builder analysisRuleType(String var1);

        public Builder analysisRuleType(ConfiguredTableAnalysisRuleType var1);

        public Builder analysisRulePolicy(ConfiguredTableAnalysisRulePolicy var1);

        default public Builder analysisRulePolicy(Consumer<ConfiguredTableAnalysisRulePolicy.Builder> analysisRulePolicy) {
            return this.analysisRulePolicy((ConfiguredTableAnalysisRulePolicy)((ConfiguredTableAnalysisRulePolicy.Builder)ConfiguredTableAnalysisRulePolicy.builder().applyMutation(analysisRulePolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

