/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredAudienceModelAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredAudienceModelAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredAudienceModelAssociationsResponse;

public class ListConfiguredAudienceModelAssociationsPublisher
implements SdkPublisher<ListConfiguredAudienceModelAssociationsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListConfiguredAudienceModelAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfiguredAudienceModelAssociationsPublisher(CleanRoomsAsyncClient client, ListConfiguredAudienceModelAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfiguredAudienceModelAssociationsPublisher(CleanRoomsAsyncClient client, ListConfiguredAudienceModelAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfiguredAudienceModelAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfiguredAudienceModelAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredAudienceModelAssociationSummary> configuredAudienceModelAssociationSummaries() {
        Function<ListConfiguredAudienceModelAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredAudienceModelAssociationSummaries() != null) {
                return response.configuredAudienceModelAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfiguredAudienceModelAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfiguredAudienceModelAssociationsResponseFetcher
    implements AsyncPageFetcher<ListConfiguredAudienceModelAssociationsResponse> {
        private ListConfiguredAudienceModelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredAudienceModelAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfiguredAudienceModelAssociationsResponse> nextPage(ListConfiguredAudienceModelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredAudienceModelAssociationsPublisher.this.client.listConfiguredAudienceModelAssociations(ListConfiguredAudienceModelAssociationsPublisher.this.firstRequest);
            }
            return ListConfiguredAudienceModelAssociationsPublisher.this.client.listConfiguredAudienceModelAssociations((ListConfiguredAudienceModelAssociationsRequest)((Object)ListConfiguredAudienceModelAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

