/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AllowedAdditionalAnalysesCopier;
import software.amazon.awssdk.services.cleanrooms.model.AllowedResultReceiversCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTableAssociationAnalysisRuleAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRuleAggregation> {
    private static final SdkField<List<String>> ALLOWED_RESULT_RECEIVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedResultReceivers").getter(ConfiguredTableAssociationAnalysisRuleAggregation.getter(ConfiguredTableAssociationAnalysisRuleAggregation::allowedResultReceivers)).setter(ConfiguredTableAssociationAnalysisRuleAggregation.setter(Builder::allowedResultReceivers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultReceivers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAdditionalAnalyses").getter(ConfiguredTableAssociationAnalysisRuleAggregation.getter(ConfiguredTableAssociationAnalysisRuleAggregation::allowedAdditionalAnalyses)).setter(ConfiguredTableAssociationAnalysisRuleAggregation.setter(Builder::allowedAdditionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAdditionalAnalyses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_RESULT_RECEIVERS_FIELD, ALLOWED_ADDITIONAL_ANALYSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfiguredTableAssociationAnalysisRuleAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allowedResultReceivers;
    private final List<String> allowedAdditionalAnalyses;

    private ConfiguredTableAssociationAnalysisRuleAggregation(BuilderImpl builder) {
        this.allowedResultReceivers = builder.allowedResultReceivers;
        this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
    }

    public final boolean hasAllowedResultReceivers() {
        return this.allowedResultReceivers != null && !(this.allowedResultReceivers instanceof SdkAutoConstructList);
    }

    public final List<String> allowedResultReceivers() {
        return this.allowedResultReceivers;
    }

    public final boolean hasAllowedAdditionalAnalyses() {
        return this.allowedAdditionalAnalyses != null && !(this.allowedAdditionalAnalyses instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAdditionalAnalyses() {
        return this.allowedAdditionalAnalyses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedResultReceivers() ? this.allowedResultReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAdditionalAnalyses() ? this.allowedAdditionalAnalyses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociationAnalysisRuleAggregation)) {
            return false;
        }
        ConfiguredTableAssociationAnalysisRuleAggregation other = (ConfiguredTableAssociationAnalysisRuleAggregation)obj;
        return this.hasAllowedResultReceivers() == other.hasAllowedResultReceivers() && Objects.equals(this.allowedResultReceivers(), other.allowedResultReceivers()) && this.hasAllowedAdditionalAnalyses() == other.hasAllowedAdditionalAnalyses() && Objects.equals(this.allowedAdditionalAnalyses(), other.allowedAdditionalAnalyses());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTableAssociationAnalysisRuleAggregation").add("AllowedResultReceivers", this.hasAllowedResultReceivers() ? this.allowedResultReceivers() : null).add("AllowedAdditionalAnalyses", this.hasAllowedAdditionalAnalyses() ? this.allowedAdditionalAnalyses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedResultReceivers": {
                return Optional.ofNullable(clazz.cast(this.allowedResultReceivers()));
            }
            case "allowedAdditionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.allowedAdditionalAnalyses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("allowedResultReceivers", ALLOWED_RESULT_RECEIVERS_FIELD);
        map.put("allowedAdditionalAnalyses", ALLOWED_ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociationAnalysisRuleAggregation, T> g) {
        return obj -> g.apply((ConfiguredTableAssociationAnalysisRuleAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedResultReceivers = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedAdditionalAnalyses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociationAnalysisRuleAggregation model) {
            this.allowedResultReceivers(model.allowedResultReceivers);
            this.allowedAdditionalAnalyses(model.allowedAdditionalAnalyses);
        }

        public final Collection<String> getAllowedResultReceivers() {
            if (this.allowedResultReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedResultReceivers;
        }

        public final void setAllowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
        }

        @Override
        public final Builder allowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultReceivers(String ... allowedResultReceivers) {
            this.allowedResultReceivers(Arrays.asList(allowedResultReceivers));
            return this;
        }

        public final Collection<String> getAllowedAdditionalAnalyses() {
            if (this.allowedAdditionalAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAdditionalAnalyses;
        }

        public final void setAllowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
        }

        @Override
        public final Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAdditionalAnalyses(String ... allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses(Arrays.asList(allowedAdditionalAnalyses));
            return this;
        }

        public ConfiguredTableAssociationAnalysisRuleAggregation build() {
            return new ConfiguredTableAssociationAnalysisRuleAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRuleAggregation> {
        public Builder allowedResultReceivers(Collection<String> var1);

        public Builder allowedResultReceivers(String ... var1);

        public Builder allowedAdditionalAnalyses(Collection<String> var1);

        public Builder allowedAdditionalAnalyses(String ... var1);
    }
}

