/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.MLMemberAbilities;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbilitiesCopier;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbility;
import software.amazon.awssdk.services.cleanrooms.model.PaymentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberSpecification> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(MemberSpecification.getter(MemberSpecification::accountId)).setter(MemberSpecification.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<List<String>> MEMBER_ABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberAbilities").getter(MemberSpecification.getter(MemberSpecification::memberAbilitiesAsStrings)).setter(MemberSpecification.setter(Builder::memberAbilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAbilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MLMemberAbilities> ML_MEMBER_ABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mlMemberAbilities").getter(MemberSpecification.getter(MemberSpecification::mlMemberAbilities)).setter(MemberSpecification.setter(Builder::mlMemberAbilities)).constructor(MLMemberAbilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlMemberAbilities").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(MemberSpecification.getter(MemberSpecification::displayName)).setter(MemberSpecification.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<PaymentConfiguration> PAYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("paymentConfiguration").getter(MemberSpecification.getter(MemberSpecification::paymentConfiguration)).setter(MemberSpecification.setter(Builder::paymentConfiguration)).constructor(PaymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, MEMBER_ABILITIES_FIELD, ML_MEMBER_ABILITIES_FIELD, DISPLAY_NAME_FIELD, PAYMENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("memberAbilities", MEMBER_ABILITIES_FIELD);
            this.put("mlMemberAbilities", ML_MEMBER_ABILITIES_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("paymentConfiguration", PAYMENT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final List<String> memberAbilities;
    private final MLMemberAbilities mlMemberAbilities;
    private final String displayName;
    private final PaymentConfiguration paymentConfiguration;

    private MemberSpecification(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.memberAbilities = builder.memberAbilities;
        this.mlMemberAbilities = builder.mlMemberAbilities;
        this.displayName = builder.displayName;
        this.paymentConfiguration = builder.paymentConfiguration;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final List<MemberAbility> memberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(this.memberAbilities);
    }

    public final boolean hasMemberAbilities() {
        return this.memberAbilities != null && !(this.memberAbilities instanceof SdkAutoConstructList);
    }

    public final List<String> memberAbilitiesAsStrings() {
        return this.memberAbilities;
    }

    public final MLMemberAbilities mlMemberAbilities() {
        return this.mlMemberAbilities;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final PaymentConfiguration paymentConfiguration() {
        return this.paymentConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberAbilities() ? this.memberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mlMemberAbilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSpecification)) {
            return false;
        }
        MemberSpecification other = (MemberSpecification)obj;
        return Objects.equals(this.accountId(), other.accountId()) && this.hasMemberAbilities() == other.hasMemberAbilities() && Objects.equals(this.memberAbilitiesAsStrings(), other.memberAbilitiesAsStrings()) && Objects.equals(this.mlMemberAbilities(), other.mlMemberAbilities()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.paymentConfiguration(), other.paymentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MemberSpecification").add("AccountId", (Object)this.accountId()).add("MemberAbilities", this.hasMemberAbilities() ? this.memberAbilitiesAsStrings() : null).add("MlMemberAbilities", (Object)this.mlMemberAbilities()).add("DisplayName", (Object)this.displayName()).add("PaymentConfiguration", (Object)this.paymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "memberAbilities": {
                return Optional.ofNullable(clazz.cast(this.memberAbilitiesAsStrings()));
            }
            case "mlMemberAbilities": {
                return Optional.ofNullable(clazz.cast(this.mlMemberAbilities()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "paymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.paymentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MemberSpecification, T> g) {
        return obj -> g.apply((MemberSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private List<String> memberAbilities = DefaultSdkAutoConstructList.getInstance();
        private MLMemberAbilities mlMemberAbilities;
        private String displayName;
        private PaymentConfiguration paymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberSpecification model) {
            this.accountId(model.accountId);
            this.memberAbilitiesWithStrings(model.memberAbilities);
            this.mlMemberAbilities(model.mlMemberAbilities);
            this.displayName(model.displayName);
            this.paymentConfiguration(model.paymentConfiguration);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getMemberAbilities() {
            if (this.memberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberAbilities;
        }

        public final void setMemberAbilities(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
        }

        @Override
        public final Builder memberAbilitiesWithStrings(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilitiesWithStrings(String ... memberAbilities) {
            this.memberAbilitiesWithStrings(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public final Builder memberAbilities(Collection<MemberAbility> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copyEnumToString(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilities(MemberAbility ... memberAbilities) {
            this.memberAbilities(Arrays.asList(memberAbilities));
            return this;
        }

        public final MLMemberAbilities.Builder getMlMemberAbilities() {
            return this.mlMemberAbilities != null ? this.mlMemberAbilities.toBuilder() : null;
        }

        public final void setMlMemberAbilities(MLMemberAbilities.BuilderImpl mlMemberAbilities) {
            this.mlMemberAbilities = mlMemberAbilities != null ? mlMemberAbilities.build() : null;
        }

        @Override
        public final Builder mlMemberAbilities(MLMemberAbilities mlMemberAbilities) {
            this.mlMemberAbilities = mlMemberAbilities;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final PaymentConfiguration.Builder getPaymentConfiguration() {
            return this.paymentConfiguration != null ? this.paymentConfiguration.toBuilder() : null;
        }

        public final void setPaymentConfiguration(PaymentConfiguration.BuilderImpl paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration != null ? paymentConfiguration.build() : null;
        }

        @Override
        public final Builder paymentConfiguration(PaymentConfiguration paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        public MemberSpecification build() {
            return new MemberSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberSpecification> {
        public Builder accountId(String var1);

        public Builder memberAbilitiesWithStrings(Collection<String> var1);

        public Builder memberAbilitiesWithStrings(String ... var1);

        public Builder memberAbilities(Collection<MemberAbility> var1);

        public Builder memberAbilities(MemberAbility ... var1);

        public Builder mlMemberAbilities(MLMemberAbilities var1);

        default public Builder mlMemberAbilities(Consumer<MLMemberAbilities.Builder> mlMemberAbilities) {
            return this.mlMemberAbilities((MLMemberAbilities)((MLMemberAbilities.Builder)MLMemberAbilities.builder().applyMutation(mlMemberAbilities)).build());
        }

        public Builder displayName(String var1);

        public Builder paymentConfiguration(PaymentConfiguration var1);

        default public Builder paymentConfiguration(Consumer<PaymentConfiguration.Builder> paymentConfiguration) {
            return this.paymentConfiguration((PaymentConfiguration)((PaymentConfiguration.Builder)PaymentConfiguration.builder().applyMutation(paymentConfiguration)).build());
        }
    }
}

