/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateError;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateErrorListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplate;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCollaborationAnalysisTemplateResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, BatchGetCollaborationAnalysisTemplateResponse> {
    private static final SdkField<List<CollaborationAnalysisTemplate>> COLLABORATION_ANALYSIS_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationAnalysisTemplates").getter(BatchGetCollaborationAnalysisTemplateResponse.getter(BatchGetCollaborationAnalysisTemplateResponse::collaborationAnalysisTemplates)).setter(BatchGetCollaborationAnalysisTemplateResponse.setter(Builder::collaborationAnalysisTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationAnalysisTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationAnalysisTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetCollaborationAnalysisTemplateError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetCollaborationAnalysisTemplateResponse.getter(BatchGetCollaborationAnalysisTemplateResponse::errors)).setter(BatchGetCollaborationAnalysisTemplateResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetCollaborationAnalysisTemplateError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_ANALYSIS_TEMPLATES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("collaborationAnalysisTemplates", COLLABORATION_ANALYSIS_TEMPLATES_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<CollaborationAnalysisTemplate> collaborationAnalysisTemplates;
    private final List<BatchGetCollaborationAnalysisTemplateError> errors;

    private BatchGetCollaborationAnalysisTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationAnalysisTemplates = builder.collaborationAnalysisTemplates;
        this.errors = builder.errors;
    }

    public final boolean hasCollaborationAnalysisTemplates() {
        return this.collaborationAnalysisTemplates != null && !(this.collaborationAnalysisTemplates instanceof SdkAutoConstructList);
    }

    public final List<CollaborationAnalysisTemplate> collaborationAnalysisTemplates() {
        return this.collaborationAnalysisTemplates;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetCollaborationAnalysisTemplateError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationAnalysisTemplates() ? this.collaborationAnalysisTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCollaborationAnalysisTemplateResponse)) {
            return false;
        }
        BatchGetCollaborationAnalysisTemplateResponse other = (BatchGetCollaborationAnalysisTemplateResponse)((Object)obj);
        return this.hasCollaborationAnalysisTemplates() == other.hasCollaborationAnalysisTemplates() && Objects.equals(this.collaborationAnalysisTemplates(), other.collaborationAnalysisTemplates()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCollaborationAnalysisTemplateResponse").add("CollaborationAnalysisTemplates", this.hasCollaborationAnalysisTemplates() ? this.collaborationAnalysisTemplates() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationAnalysisTemplates": {
                return Optional.ofNullable(clazz.cast(this.collaborationAnalysisTemplates()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCollaborationAnalysisTemplateResponse, T> g) {
        return obj -> g.apply((BatchGetCollaborationAnalysisTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<CollaborationAnalysisTemplate> collaborationAnalysisTemplates = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetCollaborationAnalysisTemplateError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCollaborationAnalysisTemplateResponse model) {
            super(model);
            this.collaborationAnalysisTemplates(model.collaborationAnalysisTemplates);
            this.errors(model.errors);
        }

        public final List<CollaborationAnalysisTemplate.Builder> getCollaborationAnalysisTemplates() {
            List<CollaborationAnalysisTemplate.Builder> result = CollaborationAnalysisTemplateListCopier.copyToBuilder(this.collaborationAnalysisTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationAnalysisTemplates(Collection<CollaborationAnalysisTemplate.BuilderImpl> collaborationAnalysisTemplates) {
            this.collaborationAnalysisTemplates = CollaborationAnalysisTemplateListCopier.copyFromBuilder(collaborationAnalysisTemplates);
        }

        @Override
        public final Builder collaborationAnalysisTemplates(Collection<CollaborationAnalysisTemplate> collaborationAnalysisTemplates) {
            this.collaborationAnalysisTemplates = CollaborationAnalysisTemplateListCopier.copy(collaborationAnalysisTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplates(CollaborationAnalysisTemplate ... collaborationAnalysisTemplates) {
            this.collaborationAnalysisTemplates(Arrays.asList(collaborationAnalysisTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplates(Consumer<CollaborationAnalysisTemplate.Builder> ... collaborationAnalysisTemplates) {
            this.collaborationAnalysisTemplates(Stream.of(collaborationAnalysisTemplates).map(c -> (CollaborationAnalysisTemplate)((CollaborationAnalysisTemplate.Builder)CollaborationAnalysisTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetCollaborationAnalysisTemplateError.Builder> getErrors() {
            List<BatchGetCollaborationAnalysisTemplateError.Builder> result = BatchGetCollaborationAnalysisTemplateErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetCollaborationAnalysisTemplateError.BuilderImpl> errors) {
            this.errors = BatchGetCollaborationAnalysisTemplateErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetCollaborationAnalysisTemplateError> errors) {
            this.errors = BatchGetCollaborationAnalysisTemplateErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetCollaborationAnalysisTemplateError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetCollaborationAnalysisTemplateError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetCollaborationAnalysisTemplateError)((BatchGetCollaborationAnalysisTemplateError.Builder)BatchGetCollaborationAnalysisTemplateError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCollaborationAnalysisTemplateResponse build() {
            return new BatchGetCollaborationAnalysisTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCollaborationAnalysisTemplateResponse> {
        public Builder collaborationAnalysisTemplates(Collection<CollaborationAnalysisTemplate> var1);

        public Builder collaborationAnalysisTemplates(CollaborationAnalysisTemplate ... var1);

        public Builder collaborationAnalysisTemplates(Consumer<CollaborationAnalysisTemplate.Builder> ... var1);

        public Builder errors(Collection<BatchGetCollaborationAnalysisTemplateError> var1);

        public Builder errors(BatchGetCollaborationAnalysisTemplateError ... var1);

        public Builder errors(Consumer<BatchGetCollaborationAnalysisTemplateError.Builder> ... var1);
    }
}

