/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationAnalysisTemplatesResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListCollaborationAnalysisTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationAnalysisTemplatesResponse.getter(ListCollaborationAnalysisTemplatesResponse::nextToken)).setter(ListCollaborationAnalysisTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationAnalysisTemplateSummary>> COLLABORATION_ANALYSIS_TEMPLATE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationAnalysisTemplateSummaries").getter(ListCollaborationAnalysisTemplatesResponse.getter(ListCollaborationAnalysisTemplatesResponse::collaborationAnalysisTemplateSummaries)).setter(ListCollaborationAnalysisTemplatesResponse.setter(Builder::collaborationAnalysisTemplateSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationAnalysisTemplateSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationAnalysisTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_ANALYSIS_TEMPLATE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("collaborationAnalysisTemplateSummaries", COLLABORATION_ANALYSIS_TEMPLATE_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries;

    private ListCollaborationAnalysisTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationAnalysisTemplateSummaries = builder.collaborationAnalysisTemplateSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationAnalysisTemplateSummaries() {
        return this.collaborationAnalysisTemplateSummaries != null && !(this.collaborationAnalysisTemplateSummaries instanceof SdkAutoConstructList);
    }

    public final List<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries() {
        return this.collaborationAnalysisTemplateSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationAnalysisTemplateSummaries() ? this.collaborationAnalysisTemplateSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationAnalysisTemplatesResponse)) {
            return false;
        }
        ListCollaborationAnalysisTemplatesResponse other = (ListCollaborationAnalysisTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationAnalysisTemplateSummaries() == other.hasCollaborationAnalysisTemplateSummaries() && Objects.equals(this.collaborationAnalysisTemplateSummaries(), other.collaborationAnalysisTemplateSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationAnalysisTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationAnalysisTemplateSummaries", this.hasCollaborationAnalysisTemplateSummaries() ? this.collaborationAnalysisTemplateSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationAnalysisTemplateSummaries": {
                return Optional.ofNullable(clazz.cast(this.collaborationAnalysisTemplateSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationAnalysisTemplatesResponse, T> g) {
        return obj -> g.apply((ListCollaborationAnalysisTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationAnalysisTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationAnalysisTemplateSummaries(model.collaborationAnalysisTemplateSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationAnalysisTemplateSummary.Builder> getCollaborationAnalysisTemplateSummaries() {
            List<CollaborationAnalysisTemplateSummary.Builder> result = CollaborationAnalysisTemplateSummaryListCopier.copyToBuilder(this.collaborationAnalysisTemplateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationAnalysisTemplateSummaries(Collection<CollaborationAnalysisTemplateSummary.BuilderImpl> collaborationAnalysisTemplateSummaries) {
            this.collaborationAnalysisTemplateSummaries = CollaborationAnalysisTemplateSummaryListCopier.copyFromBuilder(collaborationAnalysisTemplateSummaries);
        }

        @Override
        public final Builder collaborationAnalysisTemplateSummaries(Collection<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries) {
            this.collaborationAnalysisTemplateSummaries = CollaborationAnalysisTemplateSummaryListCopier.copy(collaborationAnalysisTemplateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplateSummaries(CollaborationAnalysisTemplateSummary ... collaborationAnalysisTemplateSummaries) {
            this.collaborationAnalysisTemplateSummaries(Arrays.asList(collaborationAnalysisTemplateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationAnalysisTemplateSummaries(Consumer<CollaborationAnalysisTemplateSummary.Builder> ... collaborationAnalysisTemplateSummaries) {
            this.collaborationAnalysisTemplateSummaries(Stream.of(collaborationAnalysisTemplateSummaries).map(c -> (CollaborationAnalysisTemplateSummary)((CollaborationAnalysisTemplateSummary.Builder)CollaborationAnalysisTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationAnalysisTemplatesResponse build() {
            return new ListCollaborationAnalysisTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationAnalysisTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationAnalysisTemplateSummaries(Collection<CollaborationAnalysisTemplateSummary> var1);

        public Builder collaborationAnalysisTemplateSummaries(CollaborationAnalysisTemplateSummary ... var1);

        public Builder collaborationAnalysisTemplateSummaries(Consumer<CollaborationAnalysisTemplateSummary.Builder> ... var1);
    }
}

