/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateUpdateParameters;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePrivacyBudgetTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, UpdatePrivacyBudgetTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(UpdatePrivacyBudgetTemplateRequest.getter(UpdatePrivacyBudgetTemplateRequest::membershipIdentifier)).setter(UpdatePrivacyBudgetTemplateRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetTemplateIdentifier").getter(UpdatePrivacyBudgetTemplateRequest.getter(UpdatePrivacyBudgetTemplateRequest::privacyBudgetTemplateIdentifier)).setter(UpdatePrivacyBudgetTemplateRequest.setter(Builder::privacyBudgetTemplateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("privacyBudgetTemplateIdentifier").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetType").getter(UpdatePrivacyBudgetTemplateRequest.getter(UpdatePrivacyBudgetTemplateRequest::privacyBudgetTypeAsString)).setter(UpdatePrivacyBudgetTemplateRequest.setter(Builder::privacyBudgetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetType").build()}).build();
    private static final SdkField<PrivacyBudgetTemplateUpdateParameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameters").getter(UpdatePrivacyBudgetTemplateRequest.getter(UpdatePrivacyBudgetTemplateRequest::parameters)).setter(UpdatePrivacyBudgetTemplateRequest.setter(Builder::parameters)).constructor(PrivacyBudgetTemplateUpdateParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD, PRIVACY_BUDGET_TYPE_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("privacyBudgetTemplateIdentifier", PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD);
            this.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
        }
    });
    private final String membershipIdentifier;
    private final String privacyBudgetTemplateIdentifier;
    private final String privacyBudgetType;
    private final PrivacyBudgetTemplateUpdateParameters parameters;

    private UpdatePrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.privacyBudgetTemplateIdentifier = builder.privacyBudgetTemplateIdentifier;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.parameters = builder.parameters;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String privacyBudgetTemplateIdentifier() {
        return this.privacyBudgetTemplateIdentifier;
    }

    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(this.privacyBudgetType);
    }

    public final String privacyBudgetTypeAsString() {
        return this.privacyBudgetType;
    }

    public final PrivacyBudgetTemplateUpdateParameters parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePrivacyBudgetTemplateRequest)) {
            return false;
        }
        UpdatePrivacyBudgetTemplateRequest other = (UpdatePrivacyBudgetTemplateRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.privacyBudgetTemplateIdentifier(), other.privacyBudgetTemplateIdentifier()) && Objects.equals(this.privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePrivacyBudgetTemplateRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("PrivacyBudgetTemplateIdentifier", (Object)this.privacyBudgetTemplateIdentifier()).add("PrivacyBudgetType", (Object)this.privacyBudgetTypeAsString()).add("Parameters", (Object)this.parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "privacyBudgetTemplateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTemplateIdentifier()));
            }
            case "privacyBudgetType": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTypeAsString()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((UpdatePrivacyBudgetTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String privacyBudgetTemplateIdentifier;
        private String privacyBudgetType;
        private PrivacyBudgetTemplateUpdateParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePrivacyBudgetTemplateRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.privacyBudgetTemplateIdentifier(model.privacyBudgetTemplateIdentifier);
            this.privacyBudgetType(model.privacyBudgetType);
            this.parameters(model.parameters);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getPrivacyBudgetTemplateIdentifier() {
            return this.privacyBudgetTemplateIdentifier;
        }

        public final void setPrivacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
        }

        @Override
        public final Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
            return this;
        }

        public final String getPrivacyBudgetType() {
            return this.privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final PrivacyBudgetTemplateUpdateParameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(PrivacyBudgetTemplateUpdateParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(PrivacyBudgetTemplateUpdateParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePrivacyBudgetTemplateRequest build() {
            return new UpdatePrivacyBudgetTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePrivacyBudgetTemplateRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder privacyBudgetTemplateIdentifier(String var1);

        public Builder privacyBudgetType(String var1);

        public Builder privacyBudgetType(PrivacyBudgetType var1);

        public Builder parameters(PrivacyBudgetTemplateUpdateParameters var1);

        default public Builder parameters(Consumer<PrivacyBudgetTemplateUpdateParameters.Builder> parameters) {
            return this.parameters((PrivacyBudgetTemplateUpdateParameters)((PrivacyBudgetTemplateUpdateParameters.Builder)PrivacyBudgetTemplateUpdateParameters.builder().applyMutation(parameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

