/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.PreviewPrivacyImpactParametersInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreviewPrivacyImpactRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, PreviewPrivacyImpactRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(PreviewPrivacyImpactRequest.getter(PreviewPrivacyImpactRequest::membershipIdentifier)).setter(PreviewPrivacyImpactRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<PreviewPrivacyImpactParametersInput> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameters").getter(PreviewPrivacyImpactRequest.getter(PreviewPrivacyImpactRequest::parameters)).setter(PreviewPrivacyImpactRequest.setter(Builder::parameters)).constructor(PreviewPrivacyImpactParametersInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
        }
    });
    private final String membershipIdentifier;
    private final PreviewPrivacyImpactParametersInput parameters;

    private PreviewPrivacyImpactRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.parameters = builder.parameters;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final PreviewPrivacyImpactParametersInput parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewPrivacyImpactRequest)) {
            return false;
        }
        PreviewPrivacyImpactRequest other = (PreviewPrivacyImpactRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"PreviewPrivacyImpactRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Parameters", (Object)this.parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PreviewPrivacyImpactRequest, T> g) {
        return obj -> g.apply((PreviewPrivacyImpactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private PreviewPrivacyImpactParametersInput parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewPrivacyImpactRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.parameters(model.parameters);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final PreviewPrivacyImpactParametersInput.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(PreviewPrivacyImpactParametersInput.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(PreviewPrivacyImpactParametersInput parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PreviewPrivacyImpactRequest build() {
            return new PreviewPrivacyImpactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PreviewPrivacyImpactRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder parameters(PreviewPrivacyImpactParametersInput var1);

        default public Builder parameters(Consumer<PreviewPrivacyImpactParametersInput.Builder> parameters) {
            return this.parameters((PreviewPrivacyImpactParametersInput)((PreviewPrivacyImpactParametersInput.Builder)PreviewPrivacyImpactParametersInput.builder().applyMutation(parameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

