/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AdditionalAnalyses;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleCustomAllowedAnalysesListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleCustomAllowedAnalysisProvidersListCopier;
import software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisRuleCustom
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisRuleCustom> {
    private static final SdkField<List<String>> ALLOWED_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAnalyses").getter(AnalysisRuleCustom.getter(AnalysisRuleCustom::allowedAnalyses)).setter(AnalysisRuleCustom.setter(Builder::allowedAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAnalyses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_ANALYSIS_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAnalysisProviders").getter(AnalysisRuleCustom.getter(AnalysisRuleCustom::allowedAnalysisProviders)).setter(AnalysisRuleCustom.setter(Builder::allowedAnalysisProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAnalysisProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalAnalyses").getter(AnalysisRuleCustom.getter(AnalysisRuleCustom::additionalAnalysesAsString)).setter(AnalysisRuleCustom.setter(Builder::additionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build()}).build();
    private static final SdkField<List<String>> DISALLOWED_OUTPUT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("disallowedOutputColumns").getter(AnalysisRuleCustom.getter(AnalysisRuleCustom::disallowedOutputColumns)).setter(AnalysisRuleCustom.setter(Builder::disallowedOutputColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disallowedOutputColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DifferentialPrivacyConfiguration> DIFFERENTIAL_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("differentialPrivacy").getter(AnalysisRuleCustom.getter(AnalysisRuleCustom::differentialPrivacy)).setter(AnalysisRuleCustom.setter(Builder::differentialPrivacy)).constructor(DifferentialPrivacyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ANALYSES_FIELD, ALLOWED_ANALYSIS_PROVIDERS_FIELD, ADDITIONAL_ANALYSES_FIELD, DISALLOWED_OUTPUT_COLUMNS_FIELD, DIFFERENTIAL_PRIVACY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedAnalyses;
    private final List<String> allowedAnalysisProviders;
    private final String additionalAnalyses;
    private final List<String> disallowedOutputColumns;
    private final DifferentialPrivacyConfiguration differentialPrivacy;

    private AnalysisRuleCustom(BuilderImpl builder) {
        this.allowedAnalyses = builder.allowedAnalyses;
        this.allowedAnalysisProviders = builder.allowedAnalysisProviders;
        this.additionalAnalyses = builder.additionalAnalyses;
        this.disallowedOutputColumns = builder.disallowedOutputColumns;
        this.differentialPrivacy = builder.differentialPrivacy;
    }

    public final boolean hasAllowedAnalyses() {
        return this.allowedAnalyses != null && !(this.allowedAnalyses instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAnalyses() {
        return this.allowedAnalyses;
    }

    public final boolean hasAllowedAnalysisProviders() {
        return this.allowedAnalysisProviders != null && !(this.allowedAnalysisProviders instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAnalysisProviders() {
        return this.allowedAnalysisProviders;
    }

    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(this.additionalAnalyses);
    }

    public final String additionalAnalysesAsString() {
        return this.additionalAnalyses;
    }

    public final boolean hasDisallowedOutputColumns() {
        return this.disallowedOutputColumns != null && !(this.disallowedOutputColumns instanceof SdkAutoConstructList);
    }

    public final List<String> disallowedOutputColumns() {
        return this.disallowedOutputColumns;
    }

    public final DifferentialPrivacyConfiguration differentialPrivacy() {
        return this.differentialPrivacy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAnalyses() ? this.allowedAnalyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAnalysisProviders() ? this.allowedAnalysisProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisallowedOutputColumns() ? this.disallowedOutputColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.differentialPrivacy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleCustom)) {
            return false;
        }
        AnalysisRuleCustom other = (AnalysisRuleCustom)obj;
        return this.hasAllowedAnalyses() == other.hasAllowedAnalyses() && Objects.equals(this.allowedAnalyses(), other.allowedAnalyses()) && this.hasAllowedAnalysisProviders() == other.hasAllowedAnalysisProviders() && Objects.equals(this.allowedAnalysisProviders(), other.allowedAnalysisProviders()) && Objects.equals(this.additionalAnalysesAsString(), other.additionalAnalysesAsString()) && this.hasDisallowedOutputColumns() == other.hasDisallowedOutputColumns() && Objects.equals(this.disallowedOutputColumns(), other.disallowedOutputColumns()) && Objects.equals(this.differentialPrivacy(), other.differentialPrivacy());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisRuleCustom").add("AllowedAnalyses", this.hasAllowedAnalyses() ? this.allowedAnalyses() : null).add("AllowedAnalysisProviders", this.hasAllowedAnalysisProviders() ? this.allowedAnalysisProviders() : null).add("AdditionalAnalyses", (Object)this.additionalAnalysesAsString()).add("DisallowedOutputColumns", this.hasDisallowedOutputColumns() ? this.disallowedOutputColumns() : null).add("DifferentialPrivacy", (Object)this.differentialPrivacy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedAnalyses": {
                return Optional.ofNullable(clazz.cast(this.allowedAnalyses()));
            }
            case "allowedAnalysisProviders": {
                return Optional.ofNullable(clazz.cast(this.allowedAnalysisProviders()));
            }
            case "additionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.additionalAnalysesAsString()));
            }
            case "disallowedOutputColumns": {
                return Optional.ofNullable(clazz.cast(this.disallowedOutputColumns()));
            }
            case "differentialPrivacy": {
                return Optional.ofNullable(clazz.cast(this.differentialPrivacy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleCustom, T> g) {
        return obj -> g.apply((AnalysisRuleCustom)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedAnalyses = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedAnalysisProviders = DefaultSdkAutoConstructList.getInstance();
        private String additionalAnalyses;
        private List<String> disallowedOutputColumns = DefaultSdkAutoConstructList.getInstance();
        private DifferentialPrivacyConfiguration differentialPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleCustom model) {
            this.allowedAnalyses(model.allowedAnalyses);
            this.allowedAnalysisProviders(model.allowedAnalysisProviders);
            this.additionalAnalyses(model.additionalAnalyses);
            this.disallowedOutputColumns(model.disallowedOutputColumns);
            this.differentialPrivacy(model.differentialPrivacy);
        }

        public final Collection<String> getAllowedAnalyses() {
            if (this.allowedAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAnalyses;
        }

        public final void setAllowedAnalyses(Collection<String> allowedAnalyses) {
            this.allowedAnalyses = AnalysisRuleCustomAllowedAnalysesListCopier.copy(allowedAnalyses);
        }

        @Override
        public final Builder allowedAnalyses(Collection<String> allowedAnalyses) {
            this.allowedAnalyses = AnalysisRuleCustomAllowedAnalysesListCopier.copy(allowedAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAnalyses(String ... allowedAnalyses) {
            this.allowedAnalyses(Arrays.asList(allowedAnalyses));
            return this;
        }

        public final Collection<String> getAllowedAnalysisProviders() {
            if (this.allowedAnalysisProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAnalysisProviders;
        }

        public final void setAllowedAnalysisProviders(Collection<String> allowedAnalysisProviders) {
            this.allowedAnalysisProviders = AnalysisRuleCustomAllowedAnalysisProvidersListCopier.copy(allowedAnalysisProviders);
        }

        @Override
        public final Builder allowedAnalysisProviders(Collection<String> allowedAnalysisProviders) {
            this.allowedAnalysisProviders = AnalysisRuleCustomAllowedAnalysisProvidersListCopier.copy(allowedAnalysisProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAnalysisProviders(String ... allowedAnalysisProviders) {
            this.allowedAnalysisProviders(Arrays.asList(allowedAnalysisProviders));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return this.additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        public final Collection<String> getDisallowedOutputColumns() {
            if (this.disallowedOutputColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disallowedOutputColumns;
        }

        public final void setDisallowedOutputColumns(Collection<String> disallowedOutputColumns) {
            this.disallowedOutputColumns = AnalysisRuleColumnListCopier.copy(disallowedOutputColumns);
        }

        @Override
        public final Builder disallowedOutputColumns(Collection<String> disallowedOutputColumns) {
            this.disallowedOutputColumns = AnalysisRuleColumnListCopier.copy(disallowedOutputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disallowedOutputColumns(String ... disallowedOutputColumns) {
            this.disallowedOutputColumns(Arrays.asList(disallowedOutputColumns));
            return this;
        }

        public final DifferentialPrivacyConfiguration.Builder getDifferentialPrivacy() {
            return this.differentialPrivacy != null ? this.differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyConfiguration.BuilderImpl differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyConfiguration differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy;
            return this;
        }

        public AnalysisRuleCustom build() {
            return new AnalysisRuleCustom(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisRuleCustom> {
        public Builder allowedAnalyses(Collection<String> var1);

        public Builder allowedAnalyses(String ... var1);

        public Builder allowedAnalysisProviders(Collection<String> var1);

        public Builder allowedAnalysisProviders(String ... var1);

        public Builder additionalAnalyses(String var1);

        public Builder additionalAnalyses(AdditionalAnalyses var1);

        public Builder disallowedOutputColumns(Collection<String> var1);

        public Builder disallowedOutputColumns(String ... var1);

        public Builder differentialPrivacy(DifferentialPrivacyConfiguration var1);

        default public Builder differentialPrivacy(Consumer<DifferentialPrivacyConfiguration.Builder> differentialPrivacy) {
            return this.differentialPrivacy((DifferentialPrivacyConfiguration)((DifferentialPrivacyConfiguration.Builder)DifferentialPrivacyConfiguration.builder().applyMutation(differentialPrivacy)).build());
        }
    }
}

