/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePrivacyBudgetTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, DeletePrivacyBudgetTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(DeletePrivacyBudgetTemplateRequest.getter(DeletePrivacyBudgetTemplateRequest::membershipIdentifier)).setter(DeletePrivacyBudgetTemplateRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetTemplateIdentifier").getter(DeletePrivacyBudgetTemplateRequest.getter(DeletePrivacyBudgetTemplateRequest::privacyBudgetTemplateIdentifier)).setter(DeletePrivacyBudgetTemplateRequest.setter(Builder::privacyBudgetTemplateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("privacyBudgetTemplateIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD));
    private final String membershipIdentifier;
    private final String privacyBudgetTemplateIdentifier;

    private DeletePrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.privacyBudgetTemplateIdentifier = builder.privacyBudgetTemplateIdentifier;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String privacyBudgetTemplateIdentifier() {
        return this.privacyBudgetTemplateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTemplateIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePrivacyBudgetTemplateRequest)) {
            return false;
        }
        DeletePrivacyBudgetTemplateRequest other = (DeletePrivacyBudgetTemplateRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.privacyBudgetTemplateIdentifier(), other.privacyBudgetTemplateIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePrivacyBudgetTemplateRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("PrivacyBudgetTemplateIdentifier", (Object)this.privacyBudgetTemplateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "privacyBudgetTemplateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTemplateIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((DeletePrivacyBudgetTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String privacyBudgetTemplateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePrivacyBudgetTemplateRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.privacyBudgetTemplateIdentifier(model.privacyBudgetTemplateIdentifier);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getPrivacyBudgetTemplateIdentifier() {
            return this.privacyBudgetTemplateIdentifier;
        }

        public final void setPrivacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
        }

        @Override
        public final Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePrivacyBudgetTemplateRequest build() {
            return new DeletePrivacyBudgetTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePrivacyBudgetTemplateRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder privacyBudgetTemplateIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

