/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationPrivacyBudgetTemplatesResponse;

public class ListCollaborationPrivacyBudgetTemplatesPublisher
implements SdkPublisher<ListCollaborationPrivacyBudgetTemplatesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListCollaborationPrivacyBudgetTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationPrivacyBudgetTemplatesPublisher(CleanRoomsAsyncClient client, ListCollaborationPrivacyBudgetTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationPrivacyBudgetTemplatesPublisher(CleanRoomsAsyncClient client, ListCollaborationPrivacyBudgetTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationPrivacyBudgetTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationPrivacyBudgetTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationPrivacyBudgetTemplateSummary> collaborationPrivacyBudgetTemplateSummaries() {
        Function<ListCollaborationPrivacyBudgetTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationPrivacyBudgetTemplateSummaries() != null) {
                return response.collaborationPrivacyBudgetTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationPrivacyBudgetTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationPrivacyBudgetTemplatesResponseFetcher
    implements AsyncPageFetcher<ListCollaborationPrivacyBudgetTemplatesResponse> {
        private ListCollaborationPrivacyBudgetTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationPrivacyBudgetTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationPrivacyBudgetTemplatesResponse> nextPage(ListCollaborationPrivacyBudgetTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationPrivacyBudgetTemplatesPublisher.this.client.listCollaborationPrivacyBudgetTemplates(ListCollaborationPrivacyBudgetTemplatesPublisher.this.firstRequest);
            }
            return ListCollaborationPrivacyBudgetTemplatesPublisher.this.client.listCollaborationPrivacyBudgetTemplates((ListCollaborationPrivacyBudgetTemplatesRequest)((Object)ListCollaborationPrivacyBudgetTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

