/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.MembershipPaymentConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.MembershipProtectedQueryResultConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.MembershipQueryLogStatus;
import software.amazon.awssdk.services.cleanrooms.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMembershipRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateMembershipRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(CreateMembershipRequest.getter(CreateMembershipRequest::collaborationIdentifier)).setter(CreateMembershipRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLogStatus").getter(CreateMembershipRequest.getter(CreateMembershipRequest::queryLogStatusAsString)).setter(CreateMembershipRequest.setter(Builder::queryLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMembershipRequest.getter(CreateMembershipRequest::tags)).setter(CreateMembershipRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MembershipProtectedQueryResultConfiguration> DEFAULT_RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultResultConfiguration").getter(CreateMembershipRequest.getter(CreateMembershipRequest::defaultResultConfiguration)).setter(CreateMembershipRequest.setter(Builder::defaultResultConfiguration)).constructor(MembershipProtectedQueryResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResultConfiguration").build()}).build();
    private static final SdkField<MembershipPaymentConfiguration> PAYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("paymentConfiguration").getter(CreateMembershipRequest.getter(CreateMembershipRequest::paymentConfiguration)).setter(CreateMembershipRequest.setter(Builder::paymentConfiguration)).constructor(MembershipPaymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_IDENTIFIER_FIELD, QUERY_LOG_STATUS_FIELD, TAGS_FIELD, DEFAULT_RESULT_CONFIGURATION_FIELD, PAYMENT_CONFIGURATION_FIELD));
    private final String collaborationIdentifier;
    private final String queryLogStatus;
    private final Map<String, String> tags;
    private final MembershipProtectedQueryResultConfiguration defaultResultConfiguration;
    private final MembershipPaymentConfiguration paymentConfiguration;

    private CreateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.queryLogStatus = builder.queryLogStatus;
        this.tags = builder.tags;
        this.defaultResultConfiguration = builder.defaultResultConfiguration;
        this.paymentConfiguration = builder.paymentConfiguration;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final MembershipQueryLogStatus queryLogStatus() {
        return MembershipQueryLogStatus.fromValue(this.queryLogStatus);
    }

    public final String queryLogStatusAsString() {
        return this.queryLogStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final MembershipProtectedQueryResultConfiguration defaultResultConfiguration() {
        return this.defaultResultConfiguration;
    }

    public final MembershipPaymentConfiguration paymentConfiguration() {
        return this.paymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembershipRequest)) {
            return false;
        }
        CreateMembershipRequest other = (CreateMembershipRequest)((Object)obj);
        return Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.queryLogStatusAsString(), other.queryLogStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.defaultResultConfiguration(), other.defaultResultConfiguration()) && Objects.equals(this.paymentConfiguration(), other.paymentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMembershipRequest").add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("QueryLogStatus", (Object)this.queryLogStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("DefaultResultConfiguration", (Object)this.defaultResultConfiguration()).add("PaymentConfiguration", (Object)this.paymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "queryLogStatus": {
                return Optional.ofNullable(clazz.cast(this.queryLogStatusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "defaultResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultResultConfiguration()));
            }
            case "paymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.paymentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMembershipRequest, T> g) {
        return obj -> g.apply((CreateMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String collaborationIdentifier;
        private String queryLogStatus;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private MembershipProtectedQueryResultConfiguration defaultResultConfiguration;
        private MembershipPaymentConfiguration paymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembershipRequest model) {
            super(model);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.queryLogStatus(model.queryLogStatus);
            this.tags(model.tags);
            this.defaultResultConfiguration(model.defaultResultConfiguration);
            this.paymentConfiguration(model.paymentConfiguration);
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final MembershipProtectedQueryResultConfiguration.Builder getDefaultResultConfiguration() {
            return this.defaultResultConfiguration != null ? this.defaultResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultResultConfiguration(MembershipProtectedQueryResultConfiguration.BuilderImpl defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration != null ? defaultResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        public final MembershipPaymentConfiguration.Builder getPaymentConfiguration() {
            return this.paymentConfiguration != null ? this.paymentConfiguration.toBuilder() : null;
        }

        public final void setPaymentConfiguration(MembershipPaymentConfiguration.BuilderImpl paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration != null ? paymentConfiguration.build() : null;
        }

        @Override
        public final Builder paymentConfiguration(MembershipPaymentConfiguration paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembershipRequest build() {
            return new CreateMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMembershipRequest> {
        public Builder collaborationIdentifier(String var1);

        public Builder queryLogStatus(String var1);

        public Builder queryLogStatus(MembershipQueryLogStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration var1);

        default public Builder defaultResultConfiguration(Consumer<MembershipProtectedQueryResultConfiguration.Builder> defaultResultConfiguration) {
            return this.defaultResultConfiguration((MembershipProtectedQueryResultConfiguration)((MembershipProtectedQueryResultConfiguration.Builder)MembershipProtectedQueryResultConfiguration.builder().applyMutation(defaultResultConfiguration)).build());
        }

        public Builder paymentConfiguration(MembershipPaymentConfiguration var1);

        default public Builder paymentConfiguration(Consumer<MembershipPaymentConfiguration.Builder> paymentConfiguration) {
            return this.paymentConfiguration((MembershipPaymentConfiguration)((MembershipPaymentConfiguration.Builder)MembershipPaymentConfiguration.builder().applyMutation(paymentConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

