/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesResponse;

public class ListConfiguredTablesPublisher
implements SdkPublisher<ListConfiguredTablesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListConfiguredTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfiguredTablesPublisher(CleanRoomsAsyncClient client, ListConfiguredTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfiguredTablesPublisher(CleanRoomsAsyncClient client, ListConfiguredTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfiguredTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfiguredTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredTableSummary> configuredTableSummaries() {
        Function<ListConfiguredTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredTableSummaries() != null) {
                return response.configuredTableSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfiguredTablesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfiguredTablesResponseFetcher
    implements AsyncPageFetcher<ListConfiguredTablesResponse> {
        private ListConfiguredTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfiguredTablesResponse> nextPage(ListConfiguredTablesResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredTablesPublisher.this.client.listConfiguredTables(ListConfiguredTablesPublisher.this.firstRequest);
            }
            return ListConfiguredTablesPublisher.this.client.listConfiguredTables((ListConfiguredTablesRequest)((Object)ListConfiguredTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

