/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesResponse;

public class ListCollaborationAnalysisTemplatesIterable
implements SdkIterable<ListCollaborationAnalysisTemplatesResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationAnalysisTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationAnalysisTemplatesIterable(CleanRoomsClient client, ListCollaborationAnalysisTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCollaborationAnalysisTemplatesResponseFetcher();
    }

    public Iterator<ListCollaborationAnalysisTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries() {
        Function<ListCollaborationAnalysisTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationAnalysisTemplateSummaries() != null) {
                return response.collaborationAnalysisTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationAnalysisTemplatesResponseFetcher
    implements SyncPageFetcher<ListCollaborationAnalysisTemplatesResponse> {
        private ListCollaborationAnalysisTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationAnalysisTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationAnalysisTemplatesResponse nextPage(ListCollaborationAnalysisTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationAnalysisTemplatesIterable.this.client.listCollaborationAnalysisTemplates(ListCollaborationAnalysisTemplatesIterable.this.firstRequest);
            }
            return ListCollaborationAnalysisTemplatesIterable.this.client.listCollaborationAnalysisTemplates((ListCollaborationAnalysisTemplatesRequest)((Object)ListCollaborationAnalysisTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

