/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCollaborationPrivacyBudgetTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, GetCollaborationPrivacyBudgetTemplateRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetCollaborationPrivacyBudgetTemplateRequest.getter(GetCollaborationPrivacyBudgetTemplateRequest::collaborationIdentifier)).setter(GetCollaborationPrivacyBudgetTemplateRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privacyBudgetTemplateIdentifier").getter(GetCollaborationPrivacyBudgetTemplateRequest.getter(GetCollaborationPrivacyBudgetTemplateRequest::privacyBudgetTemplateIdentifier)).setter(GetCollaborationPrivacyBudgetTemplateRequest.setter(Builder::privacyBudgetTemplateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("privacyBudgetTemplateIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_IDENTIFIER_FIELD, PRIVACY_BUDGET_TEMPLATE_IDENTIFIER_FIELD));
    private final String collaborationIdentifier;
    private final String privacyBudgetTemplateIdentifier;

    private GetCollaborationPrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.privacyBudgetTemplateIdentifier = builder.privacyBudgetTemplateIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String privacyBudgetTemplateIdentifier() {
        return this.privacyBudgetTemplateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyBudgetTemplateIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationPrivacyBudgetTemplateRequest)) {
            return false;
        }
        GetCollaborationPrivacyBudgetTemplateRequest other = (GetCollaborationPrivacyBudgetTemplateRequest)((Object)obj);
        return Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.privacyBudgetTemplateIdentifier(), other.privacyBudgetTemplateIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetCollaborationPrivacyBudgetTemplateRequest").add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("PrivacyBudgetTemplateIdentifier", (Object)this.privacyBudgetTemplateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "privacyBudgetTemplateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.privacyBudgetTemplateIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationPrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((GetCollaborationPrivacyBudgetTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String collaborationIdentifier;
        private String privacyBudgetTemplateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationPrivacyBudgetTemplateRequest model) {
            super(model);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.privacyBudgetTemplateIdentifier(model.privacyBudgetTemplateIdentifier);
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getPrivacyBudgetTemplateIdentifier() {
            return this.privacyBudgetTemplateIdentifier;
        }

        public final void setPrivacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
        }

        @Override
        public final Builder privacyBudgetTemplateIdentifier(String privacyBudgetTemplateIdentifier) {
            this.privacyBudgetTemplateIdentifier = privacyBudgetTemplateIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCollaborationPrivacyBudgetTemplateRequest build() {
            return new GetCollaborationPrivacyBudgetTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCollaborationPrivacyBudgetTemplateRequest> {
        public Builder collaborationIdentifier(String var1);

        public Builder privacyBudgetTemplateIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

