/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The membership object listed by the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipSummary.Builder, MembershipSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MembershipSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(MembershipSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(MembershipSummary::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(MembershipSummary::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_CREATOR_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("collaborationCreatorAccountId")
            .getter(getter(MembershipSummary::collaborationCreatorAccountId))
            .setter(setter(Builder::collaborationCreatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationCreatorAccountId")
                    .build()).build();

    private static final SdkField<String> COLLABORATION_CREATOR_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("collaborationCreatorDisplayName")
            .getter(getter(MembershipSummary::collaborationCreatorDisplayName))
            .setter(setter(Builder::collaborationCreatorDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationCreatorDisplayName")
                    .build()).build();

    private static final SdkField<String> COLLABORATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationName").getter(getter(MembershipSummary::collaborationName))
            .setter(setter(Builder::collaborationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationName").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(MembershipSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(MembershipSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MembershipSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> MEMBER_ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("memberAbilities")
            .getter(getter(MembershipSummary::memberAbilitiesAsStrings))
            .setter(setter(Builder::memberAbilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAbilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            COLLABORATION_ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_CREATOR_ACCOUNT_ID_FIELD,
            COLLABORATION_CREATOR_DISPLAY_NAME_FIELD, COLLABORATION_NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            STATUS_FIELD, MEMBER_ABILITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String collaborationArn;

    private final String collaborationId;

    private final String collaborationCreatorAccountId;

    private final String collaborationCreatorDisplayName;

    private final String collaborationName;

    private final Instant createTime;

    private final Instant updateTime;

    private final String status;

    private final List<String> memberAbilities;

    private MembershipSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.collaborationArn = builder.collaborationArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationCreatorAccountId = builder.collaborationCreatorAccountId;
        this.collaborationCreatorDisplayName = builder.collaborationCreatorDisplayName;
        this.collaborationName = builder.collaborationName;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.status = builder.status;
        this.memberAbilities = builder.memberAbilities;
    }

    /**
     * <p>
     * The unique ID for the membership's collaboration.
     * </p>
     * 
     * @return The unique ID for the membership's collaboration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique ARN for the membership.
     * </p>
     * 
     * @return The unique ARN for the membership.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique ARN for the membership's associated collaboration.
     * </p>
     * 
     * @return The unique ARN for the membership's associated collaboration.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The unique ID for the membership's collaboration.
     * </p>
     * 
     * @return The unique ID for the membership's collaboration.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services principal that created the collaboration. Currently only supports
     * Amazon Web Services account ID.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services principal that created the collaboration. Currently only
     *         supports Amazon Web Services account ID.
     */
    public final String collaborationCreatorAccountId() {
        return collaborationCreatorAccountId;
    }

    /**
     * <p>
     * The display name of the collaboration creator.
     * </p>
     * 
     * @return The display name of the collaboration creator.
     */
    public final String collaborationCreatorDisplayName() {
        return collaborationCreatorDisplayName;
    }

    /**
     * <p>
     * The name for the membership's collaboration.
     * </p>
     * 
     * @return The name for the membership's collaboration.
     */
    public final String collaborationName() {
        return collaborationName;
    }

    /**
     * <p>
     * The time when the membership was created.
     * </p>
     * 
     * @return The time when the membership was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the membership metadata was last updated.
     * </p>
     * 
     * @return The time the membership metadata was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
     * @see MembershipStatus
     */
    public final MembershipStatus status() {
        return MembershipStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
     * @see MembershipStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<MemberAbility> memberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(memberAbilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberAbilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberAbilities() {
        return memberAbilities != null && !(memberAbilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<String> memberAbilitiesAsStrings() {
        return memberAbilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationCreatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationCreatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberAbilities() ? memberAbilitiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipSummary)) {
            return false;
        }
        MembershipSummary other = (MembershipSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationCreatorAccountId(), other.collaborationCreatorAccountId())
                && Objects.equals(collaborationCreatorDisplayName(), other.collaborationCreatorDisplayName())
                && Objects.equals(collaborationName(), other.collaborationName())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasMemberAbilities() == other.hasMemberAbilities()
                && Objects.equals(memberAbilitiesAsStrings(), other.memberAbilitiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipSummary").add("Id", id()).add("Arn", arn())
                .add("CollaborationArn", collaborationArn()).add("CollaborationId", collaborationId())
                .add("CollaborationCreatorAccountId", collaborationCreatorAccountId())
                .add("CollaborationCreatorDisplayName", collaborationCreatorDisplayName())
                .add("CollaborationName", collaborationName()).add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("Status", statusAsString()).add("MemberAbilities", hasMemberAbilities() ? memberAbilitiesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationCreatorAccountId":
            return Optional.ofNullable(clazz.cast(collaborationCreatorAccountId()));
        case "collaborationCreatorDisplayName":
            return Optional.ofNullable(clazz.cast(collaborationCreatorDisplayName()));
        case "collaborationName":
            return Optional.ofNullable(clazz.cast(collaborationName()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "memberAbilities":
            return Optional.ofNullable(clazz.cast(memberAbilitiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MembershipSummary, T> g) {
        return obj -> g.apply((MembershipSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipSummary> {
        /**
         * <p>
         * The unique ID for the membership's collaboration.
         * </p>
         * 
         * @param id
         *        The unique ID for the membership's collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ARN for the membership.
         * </p>
         * 
         * @param arn
         *        The unique ARN for the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique ARN for the membership's associated collaboration.
         * </p>
         * 
         * @param collaborationArn
         *        The unique ARN for the membership's associated collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The unique ID for the membership's collaboration.
         * </p>
         * 
         * @param collaborationId
         *        The unique ID for the membership's collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The identifier of the Amazon Web Services principal that created the collaboration. Currently only supports
         * Amazon Web Services account ID.
         * </p>
         * 
         * @param collaborationCreatorAccountId
         *        The identifier of the Amazon Web Services principal that created the collaboration. Currently only
         *        supports Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationCreatorAccountId(String collaborationCreatorAccountId);

        /**
         * <p>
         * The display name of the collaboration creator.
         * </p>
         * 
         * @param collaborationCreatorDisplayName
         *        The display name of the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationCreatorDisplayName(String collaborationCreatorDisplayName);

        /**
         * <p>
         * The name for the membership's collaboration.
         * </p>
         * 
         * @param collaborationName
         *        The name for the membership's collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationName(String collaborationName);

        /**
         * <p>
         * The time when the membership was created.
         * </p>
         * 
         * @param createTime
         *        The time when the membership was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the membership metadata was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the membership metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
         * </p>
         * 
         * @param status
         *        The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
         * </p>
         * 
         * @param status
         *        The status of the membership. Valid values are `ACTIVE`, `REMOVED`, and `COLLABORATION_DELETED`.
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder status(MembershipStatus status);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(Collection<String> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(String... memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(Collection<MemberAbility> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(MemberAbility... memberAbilities);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String collaborationArn;

        private String collaborationId;

        private String collaborationCreatorAccountId;

        private String collaborationCreatorDisplayName;

        private String collaborationName;

        private Instant createTime;

        private Instant updateTime;

        private String status;

        private List<String> memberAbilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipSummary model) {
            id(model.id);
            arn(model.arn);
            collaborationArn(model.collaborationArn);
            collaborationId(model.collaborationId);
            collaborationCreatorAccountId(model.collaborationCreatorAccountId);
            collaborationCreatorDisplayName(model.collaborationCreatorDisplayName);
            collaborationName(model.collaborationName);
            createTime(model.createTime);
            updateTime(model.updateTime);
            status(model.status);
            memberAbilitiesWithStrings(model.memberAbilities);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationCreatorAccountId() {
            return collaborationCreatorAccountId;
        }

        public final void setCollaborationCreatorAccountId(String collaborationCreatorAccountId) {
            this.collaborationCreatorAccountId = collaborationCreatorAccountId;
        }

        @Override
        public final Builder collaborationCreatorAccountId(String collaborationCreatorAccountId) {
            this.collaborationCreatorAccountId = collaborationCreatorAccountId;
            return this;
        }

        public final String getCollaborationCreatorDisplayName() {
            return collaborationCreatorDisplayName;
        }

        public final void setCollaborationCreatorDisplayName(String collaborationCreatorDisplayName) {
            this.collaborationCreatorDisplayName = collaborationCreatorDisplayName;
        }

        @Override
        public final Builder collaborationCreatorDisplayName(String collaborationCreatorDisplayName) {
            this.collaborationCreatorDisplayName = collaborationCreatorDisplayName;
            return this;
        }

        public final String getCollaborationName() {
            return collaborationName;
        }

        public final void setCollaborationName(String collaborationName) {
            this.collaborationName = collaborationName;
        }

        @Override
        public final Builder collaborationName(String collaborationName) {
            this.collaborationName = collaborationName;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MembershipStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getMemberAbilities() {
            if (memberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return memberAbilities;
        }

        public final void setMemberAbilities(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
        }

        @Override
        public final Builder memberAbilitiesWithStrings(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilitiesWithStrings(String... memberAbilities) {
            memberAbilitiesWithStrings(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public final Builder memberAbilities(Collection<MemberAbility> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copyEnumToString(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilities(MemberAbility... memberAbilities) {
            memberAbilities(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public MembershipSummary build() {
            return new MembershipSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
