/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Basic metadata used to construct a new member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberSpecification.Builder, MemberSpecification> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(MemberSpecification::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<List<String>> MEMBER_ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("memberAbilities")
            .getter(getter(MemberSpecification::memberAbilitiesAsStrings))
            .setter(setter(Builder::memberAbilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAbilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(MemberSpecification::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            MEMBER_ABILITIES_FIELD, DISPLAY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final List<String> memberAbilities;

    private final String displayName;

    private MemberSpecification(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.memberAbilities = builder.memberAbilities;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
     * account ID.
     * </p>
     * 
     * @return The identifier used to reference members of the collaboration. Currently only supports Amazon Web
     *         Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<MemberAbility> memberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(memberAbilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberAbilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberAbilities() {
        return memberAbilities != null && !(memberAbilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<String> memberAbilitiesAsStrings() {
        return memberAbilities;
    }

    /**
     * <p>
     * The member's display name.
     * </p>
     * 
     * @return The member's display name.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberAbilities() ? memberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSpecification)) {
            return false;
        }
        MemberSpecification other = (MemberSpecification) obj;
        return Objects.equals(accountId(), other.accountId()) && hasMemberAbilities() == other.hasMemberAbilities()
                && Objects.equals(memberAbilitiesAsStrings(), other.memberAbilitiesAsStrings())
                && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberSpecification").add("AccountId", accountId())
                .add("MemberAbilities", hasMemberAbilities() ? memberAbilitiesAsStrings() : null)
                .add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "memberAbilities":
            return Optional.ofNullable(clazz.cast(memberAbilitiesAsStrings()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberSpecification, T> g) {
        return obj -> g.apply((MemberSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberSpecification> {
        /**
         * <p>
         * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
         * account ID.
         * </p>
         * 
         * @param accountId
         *        The identifier used to reference members of the collaboration. Currently only supports Amazon Web
         *        Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(Collection<String> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(String... memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(Collection<MemberAbility> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(MemberAbility... memberAbilities);

        /**
         * <p>
         * The member's display name.
         * </p>
         * 
         * @param displayName
         *        The member's display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private List<String> memberAbilities = DefaultSdkAutoConstructList.getInstance();

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberSpecification model) {
            accountId(model.accountId);
            memberAbilitiesWithStrings(model.memberAbilities);
            displayName(model.displayName);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getMemberAbilities() {
            if (memberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return memberAbilities;
        }

        public final void setMemberAbilities(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
        }

        @Override
        public final Builder memberAbilitiesWithStrings(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilitiesWithStrings(String... memberAbilities) {
            memberAbilitiesWithStrings(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public final Builder memberAbilities(Collection<MemberAbility> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copyEnumToString(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilities(MemberAbility... memberAbilities) {
            memberAbilities(Arrays.asList(memberAbilities));
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public MemberSpecification build() {
            return new MemberSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
