/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configured table association summary for the objects listed by the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredTableAssociationSummary.Builder, ConfiguredTableAssociationSummary> {
    private static final SdkField<String> CONFIGURED_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableId").getter(getter(ConfiguredTableAssociationSummary::configuredTableId))
            .setter(setter(Builder::configuredTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ConfiguredTableAssociationSummary::membershipId))
            .setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ConfiguredTableAssociationSummary::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfiguredTableAssociationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ConfiguredTableAssociationSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(ConfiguredTableAssociationSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ConfiguredTableAssociationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ConfiguredTableAssociationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_ID_FIELD,
            MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ID_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configuredTableId;

    private final String membershipId;

    private final String membershipArn;

    private final String name;

    private final Instant createTime;

    private final Instant updateTime;

    private final String id;

    private final String arn;

    private ConfiguredTableAssociationSummary(BuilderImpl builder) {
        this.configuredTableId = builder.configuredTableId;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.id = builder.id;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The unique configured table ID that this configured table association refers to.
     * </p>
     * 
     * @return The unique configured table ID that this configured table association refers to.
     */
    public final String configuredTableId() {
        return configuredTableId;
    }

    /**
     * <p>
     * The unique ID for the membership that the configured table association belongs to.
     * </p>
     * 
     * @return The unique ID for the membership that the configured table association belongs to.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The unique ARN for the membership that the configured table association belongs to.
     * </p>
     * 
     * @return The unique ARN for the membership that the configured table association belongs to.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The name of the configured table association. The table is identified by this name when running Protected Queries
     * against the underlying data.
     * </p>
     * 
     * @return The name of the configured table association. The table is identified by this name when running Protected
     *         Queries against the underlying data.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time the configured table association was created.
     * </p>
     * 
     * @return The time the configured table association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the configured table association was last updated.
     * </p>
     * 
     * @return The time the configured table association was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The unique ID for the configured table association.
     * </p>
     * 
     * @return The unique ID for the configured table association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique ARN for the configured table association.
     * </p>
     * 
     * @return The unique ARN for the configured table association.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociationSummary)) {
            return false;
        }
        ConfiguredTableAssociationSummary other = (ConfiguredTableAssociationSummary) obj;
        return Objects.equals(configuredTableId(), other.configuredTableId())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(name(), other.name()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(id(), other.id())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableAssociationSummary").add("ConfiguredTableId", configuredTableId())
                .add("MembershipId", membershipId()).add("MembershipArn", membershipArn()).add("Name", name())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("Id", id()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableId":
            return Optional.ofNullable(clazz.cast(configuredTableId()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociationSummary, T> g) {
        return obj -> g.apply((ConfiguredTableAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableAssociationSummary> {
        /**
         * <p>
         * The unique configured table ID that this configured table association refers to.
         * </p>
         * 
         * @param configuredTableId
         *        The unique configured table ID that this configured table association refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableId(String configuredTableId);

        /**
         * <p>
         * The unique ID for the membership that the configured table association belongs to.
         * </p>
         * 
         * @param membershipId
         *        The unique ID for the membership that the configured table association belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The unique ARN for the membership that the configured table association belongs to.
         * </p>
         * 
         * @param membershipArn
         *        The unique ARN for the membership that the configured table association belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The name of the configured table association. The table is identified by this name when running Protected
         * Queries against the underlying data.
         * </p>
         * 
         * @param name
         *        The name of the configured table association. The table is identified by this name when running
         *        Protected Queries against the underlying data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the configured table association was created.
         * </p>
         * 
         * @param createTime
         *        The time the configured table association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the configured table association was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the configured table association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The unique ID for the configured table association.
         * </p>
         * 
         * @param id
         *        The unique ID for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ARN for the configured table association.
         * </p>
         * 
         * @param arn
         *        The unique ARN for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String configuredTableId;

        private String membershipId;

        private String membershipArn;

        private String name;

        private Instant createTime;

        private Instant updateTime;

        private String id;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociationSummary model) {
            configuredTableId(model.configuredTableId);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            name(model.name);
            createTime(model.createTime);
            updateTime(model.updateTime);
            id(model.id);
            arn(model.arn);
        }

        public final String getConfiguredTableId() {
            return configuredTableId;
        }

        public final void setConfiguredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
        }

        @Override
        public final Builder configuredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public ConfiguredTableAssociationSummary build() {
            return new ConfiguredTableAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
