/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsResponse;

public class ListConfiguredTableAssociationsIterable
implements SdkIterable<ListConfiguredTableAssociationsResponse> {
    private final CleanRoomsClient client;
    private final ListConfiguredTableAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfiguredTableAssociationsIterable(CleanRoomsClient client, ListConfiguredTableAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConfiguredTableAssociationsResponseFetcher();
    }

    public Iterator<ListConfiguredTableAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfiguredTableAssociationSummary> configuredTableAssociationSummaries() {
        Function<ListConfiguredTableAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredTableAssociationSummaries() != null) {
                return response.configuredTableAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfiguredTableAssociationsResponseFetcher
    implements SyncPageFetcher<ListConfiguredTableAssociationsResponse> {
        private ListConfiguredTableAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredTableAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfiguredTableAssociationsResponse nextPage(ListConfiguredTableAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredTableAssociationsIterable.this.client.listConfiguredTableAssociations(ListConfiguredTableAssociationsIterable.this.firstRequest);
            }
            return ListConfiguredTableAssociationsIterable.this.client.listConfiguredTableAssociations((ListConfiguredTableAssociationsRequest)((Object)ListConfiguredTableAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

