/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.AllowedColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.TableReference;
import software.amazon.awssdk.services.cleanrooms.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfiguredTableRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateConfiguredTableRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateConfiguredTableRequest.getter(CreateConfiguredTableRequest::name)).setter(CreateConfiguredTableRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateConfiguredTableRequest.getter(CreateConfiguredTableRequest::description)).setter(CreateConfiguredTableRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TableReference> TABLE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tableReference").getter(CreateConfiguredTableRequest.getter(CreateConfiguredTableRequest::tableReference)).setter(CreateConfiguredTableRequest.setter(Builder::tableReference)).constructor(TableReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableReference").build()}).build();
    private static final SdkField<List<String>> ALLOWED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedColumns").getter(CreateConfiguredTableRequest.getter(CreateConfiguredTableRequest::allowedColumns)).setter(CreateConfiguredTableRequest.setter(Builder::allowedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisMethod").getter(CreateConfiguredTableRequest.getter(CreateConfiguredTableRequest::analysisMethodAsString)).setter(CreateConfiguredTableRequest.setter(Builder::analysisMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConfiguredTableRequest.getter(CreateConfiguredTableRequest::tags)).setter(CreateConfiguredTableRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TABLE_REFERENCE_FIELD, ALLOWED_COLUMNS_FIELD, ANALYSIS_METHOD_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final TableReference tableReference;
    private final List<String> allowedColumns;
    private final String analysisMethod;
    private final Map<String, String> tags;

    private CreateConfiguredTableRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.tableReference = builder.tableReference;
        this.allowedColumns = builder.allowedColumns;
        this.analysisMethod = builder.analysisMethod;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TableReference tableReference() {
        return this.tableReference;
    }

    public final boolean hasAllowedColumns() {
        return this.allowedColumns != null && !(this.allowedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> allowedColumns() {
        return this.allowedColumns;
    }

    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(this.analysisMethod);
    }

    public final String analysisMethodAsString() {
        return this.analysisMethod;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedColumns() ? this.allowedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredTableRequest)) {
            return false;
        }
        CreateConfiguredTableRequest other = (CreateConfiguredTableRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.tableReference(), other.tableReference()) && this.hasAllowedColumns() == other.hasAllowedColumns() && Objects.equals(this.allowedColumns(), other.allowedColumns()) && Objects.equals(this.analysisMethodAsString(), other.analysisMethodAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfiguredTableRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TableReference", (Object)this.tableReference()).add("AllowedColumns", this.hasAllowedColumns() ? this.allowedColumns() : null).add("AnalysisMethod", (Object)this.analysisMethodAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tableReference": {
                return Optional.ofNullable(clazz.cast(this.tableReference()));
            }
            case "allowedColumns": {
                return Optional.ofNullable(clazz.cast(this.allowedColumns()));
            }
            case "analysisMethod": {
                return Optional.ofNullable(clazz.cast(this.analysisMethodAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredTableRequest, T> g) {
        return obj -> g.apply((CreateConfiguredTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private TableReference tableReference;
        private List<String> allowedColumns = DefaultSdkAutoConstructList.getInstance();
        private String analysisMethod;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredTableRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.tableReference(model.tableReference);
            this.allowedColumns(model.allowedColumns);
            this.analysisMethod(model.analysisMethod);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TableReference.Builder getTableReference() {
            return this.tableReference != null ? this.tableReference.toBuilder() : null;
        }

        public final void setTableReference(TableReference.BuilderImpl tableReference) {
            this.tableReference = tableReference != null ? tableReference.build() : null;
        }

        @Override
        public final Builder tableReference(TableReference tableReference) {
            this.tableReference = tableReference;
            return this;
        }

        public final Collection<String> getAllowedColumns() {
            if (this.allowedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedColumns;
        }

        public final void setAllowedColumns(Collection<String> allowedColumns) {
            this.allowedColumns = AllowedColumnListCopier.copy(allowedColumns);
        }

        @Override
        public final Builder allowedColumns(Collection<String> allowedColumns) {
            this.allowedColumns = AllowedColumnListCopier.copy(allowedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedColumns(String ... allowedColumns) {
            this.allowedColumns(Arrays.asList(allowedColumns));
            return this;
        }

        public final String getAnalysisMethod() {
            return this.analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredTableRequest build() {
            return new CreateConfiguredTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfiguredTableRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tableReference(TableReference var1);

        default public Builder tableReference(Consumer<TableReference.Builder> tableReference) {
            return this.tableReference((TableReference)((TableReference.Builder)TableReference.builder().applyMutation(tableReference)).build());
        }

        public Builder allowedColumns(Collection<String> var1);

        public Builder allowedColumns(String ... var1);

        public Builder analysisMethod(String var1);

        public Builder analysisMethod(AnalysisMethod var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

