/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbilitiesCopier;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbility;
import software.amazon.awssdk.services.cleanrooms.model.MembershipProtectedQueryResultConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.MembershipQueryLogStatus;
import software.amazon.awssdk.services.cleanrooms.model.MembershipStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Membership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Membership> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Membership.getter(Membership::id)).setter(Membership.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Membership.getter(Membership::arn)).setter(Membership.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationArn").getter(Membership.getter(Membership::collaborationArn)).setter(Membership.setter(Builder::collaborationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(Membership.getter(Membership::collaborationId)).setter(Membership.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<String> COLLABORATION_CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationCreatorAccountId").getter(Membership.getter(Membership::collaborationCreatorAccountId)).setter(Membership.setter(Builder::collaborationCreatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationCreatorAccountId").build()}).build();
    private static final SdkField<String> COLLABORATION_CREATOR_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationCreatorDisplayName").getter(Membership.getter(Membership::collaborationCreatorDisplayName)).setter(Membership.setter(Builder::collaborationCreatorDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationCreatorDisplayName").build()}).build();
    private static final SdkField<String> COLLABORATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationName").getter(Membership.getter(Membership::collaborationName)).setter(Membership.setter(Builder::collaborationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(Membership.getter(Membership::createTime)).setter(Membership.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(Membership.getter(Membership::updateTime)).setter(Membership.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Membership.getter(Membership::statusAsString)).setter(Membership.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> MEMBER_ABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberAbilities").getter(Membership.getter(Membership::memberAbilitiesAsStrings)).setter(Membership.setter(Builder::memberAbilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAbilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLogStatus").getter(Membership.getter(Membership::queryLogStatusAsString)).setter(Membership.setter(Builder::queryLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()}).build();
    private static final SdkField<MembershipProtectedQueryResultConfiguration> DEFAULT_RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultResultConfiguration").getter(Membership.getter(Membership::defaultResultConfiguration)).setter(Membership.setter(Builder::defaultResultConfiguration)).constructor(MembershipProtectedQueryResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResultConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, COLLABORATION_ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_CREATOR_ACCOUNT_ID_FIELD, COLLABORATION_CREATOR_DISPLAY_NAME_FIELD, COLLABORATION_NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, STATUS_FIELD, MEMBER_ABILITIES_FIELD, QUERY_LOG_STATUS_FIELD, DEFAULT_RESULT_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String collaborationArn;
    private final String collaborationId;
    private final String collaborationCreatorAccountId;
    private final String collaborationCreatorDisplayName;
    private final String collaborationName;
    private final Instant createTime;
    private final Instant updateTime;
    private final String status;
    private final List<String> memberAbilities;
    private final String queryLogStatus;
    private final MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

    private Membership(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.collaborationArn = builder.collaborationArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationCreatorAccountId = builder.collaborationCreatorAccountId;
        this.collaborationCreatorDisplayName = builder.collaborationCreatorDisplayName;
        this.collaborationName = builder.collaborationName;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.status = builder.status;
        this.memberAbilities = builder.memberAbilities;
        this.queryLogStatus = builder.queryLogStatus;
        this.defaultResultConfiguration = builder.defaultResultConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String collaborationArn() {
        return this.collaborationArn;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final String collaborationCreatorAccountId() {
        return this.collaborationCreatorAccountId;
    }

    public final String collaborationCreatorDisplayName() {
        return this.collaborationCreatorDisplayName;
    }

    public final String collaborationName() {
        return this.collaborationName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final MembershipStatus status() {
        return MembershipStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final List<MemberAbility> memberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(this.memberAbilities);
    }

    public final boolean hasMemberAbilities() {
        return this.memberAbilities != null && !(this.memberAbilities instanceof SdkAutoConstructList);
    }

    public final List<String> memberAbilitiesAsStrings() {
        return this.memberAbilities;
    }

    public final MembershipQueryLogStatus queryLogStatus() {
        return MembershipQueryLogStatus.fromValue(this.queryLogStatus);
    }

    public final String queryLogStatusAsString() {
        return this.queryLogStatus;
    }

    public final MembershipProtectedQueryResultConfiguration defaultResultConfiguration() {
        return this.defaultResultConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationCreatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationCreatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberAbilities() ? this.memberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResultConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Membership)) {
            return false;
        }
        Membership other = (Membership)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.collaborationArn(), other.collaborationArn()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.collaborationCreatorAccountId(), other.collaborationCreatorAccountId()) && Objects.equals(this.collaborationCreatorDisplayName(), other.collaborationCreatorDisplayName()) && Objects.equals(this.collaborationName(), other.collaborationName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasMemberAbilities() == other.hasMemberAbilities() && Objects.equals(this.memberAbilitiesAsStrings(), other.memberAbilitiesAsStrings()) && Objects.equals(this.queryLogStatusAsString(), other.queryLogStatusAsString()) && Objects.equals(this.defaultResultConfiguration(), other.defaultResultConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Membership").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CollaborationArn", (Object)this.collaborationArn()).add("CollaborationId", (Object)this.collaborationId()).add("CollaborationCreatorAccountId", (Object)this.collaborationCreatorAccountId()).add("CollaborationCreatorDisplayName", (Object)this.collaborationCreatorDisplayName()).add("CollaborationName", (Object)this.collaborationName()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Status", (Object)this.statusAsString()).add("MemberAbilities", this.hasMemberAbilities() ? this.memberAbilitiesAsStrings() : null).add("QueryLogStatus", (Object)this.queryLogStatusAsString()).add("DefaultResultConfiguration", (Object)this.defaultResultConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "collaborationArn": {
                return Optional.ofNullable(clazz.cast(this.collaborationArn()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "collaborationCreatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.collaborationCreatorAccountId()));
            }
            case "collaborationCreatorDisplayName": {
                return Optional.ofNullable(clazz.cast(this.collaborationCreatorDisplayName()));
            }
            case "collaborationName": {
                return Optional.ofNullable(clazz.cast(this.collaborationName()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "memberAbilities": {
                return Optional.ofNullable(clazz.cast(this.memberAbilitiesAsStrings()));
            }
            case "queryLogStatus": {
                return Optional.ofNullable(clazz.cast(this.queryLogStatusAsString()));
            }
            case "defaultResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultResultConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Membership, T> g) {
        return obj -> g.apply((Membership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String collaborationArn;
        private String collaborationId;
        private String collaborationCreatorAccountId;
        private String collaborationCreatorDisplayName;
        private String collaborationName;
        private Instant createTime;
        private Instant updateTime;
        private String status;
        private List<String> memberAbilities = DefaultSdkAutoConstructList.getInstance();
        private String queryLogStatus;
        private MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Membership model) {
            this.id(model.id);
            this.arn(model.arn);
            this.collaborationArn(model.collaborationArn);
            this.collaborationId(model.collaborationId);
            this.collaborationCreatorAccountId(model.collaborationCreatorAccountId);
            this.collaborationCreatorDisplayName(model.collaborationCreatorDisplayName);
            this.collaborationName(model.collaborationName);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.status(model.status);
            this.memberAbilitiesWithStrings(model.memberAbilities);
            this.queryLogStatus(model.queryLogStatus);
            this.defaultResultConfiguration(model.defaultResultConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCollaborationArn() {
            return this.collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationCreatorAccountId() {
            return this.collaborationCreatorAccountId;
        }

        public final void setCollaborationCreatorAccountId(String collaborationCreatorAccountId) {
            this.collaborationCreatorAccountId = collaborationCreatorAccountId;
        }

        @Override
        public final Builder collaborationCreatorAccountId(String collaborationCreatorAccountId) {
            this.collaborationCreatorAccountId = collaborationCreatorAccountId;
            return this;
        }

        public final String getCollaborationCreatorDisplayName() {
            return this.collaborationCreatorDisplayName;
        }

        public final void setCollaborationCreatorDisplayName(String collaborationCreatorDisplayName) {
            this.collaborationCreatorDisplayName = collaborationCreatorDisplayName;
        }

        @Override
        public final Builder collaborationCreatorDisplayName(String collaborationCreatorDisplayName) {
            this.collaborationCreatorDisplayName = collaborationCreatorDisplayName;
            return this;
        }

        public final String getCollaborationName() {
            return this.collaborationName;
        }

        public final void setCollaborationName(String collaborationName) {
            this.collaborationName = collaborationName;
        }

        @Override
        public final Builder collaborationName(String collaborationName) {
            this.collaborationName = collaborationName;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MembershipStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getMemberAbilities() {
            if (this.memberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberAbilities;
        }

        public final void setMemberAbilities(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
        }

        @Override
        public final Builder memberAbilitiesWithStrings(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilitiesWithStrings(String ... memberAbilities) {
            this.memberAbilitiesWithStrings(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public final Builder memberAbilities(Collection<MemberAbility> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copyEnumToString(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilities(MemberAbility ... memberAbilities) {
            this.memberAbilities(Arrays.asList(memberAbilities));
            return this;
        }

        public final String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final MembershipProtectedQueryResultConfiguration.Builder getDefaultResultConfiguration() {
            return this.defaultResultConfiguration != null ? this.defaultResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultResultConfiguration(MembershipProtectedQueryResultConfiguration.BuilderImpl defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration != null ? defaultResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        public Membership build() {
            return new Membership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Membership> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder collaborationArn(String var1);

        public Builder collaborationId(String var1);

        public Builder collaborationCreatorAccountId(String var1);

        public Builder collaborationCreatorDisplayName(String var1);

        public Builder collaborationName(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(MembershipStatus var1);

        public Builder memberAbilitiesWithStrings(Collection<String> var1);

        public Builder memberAbilitiesWithStrings(String ... var1);

        public Builder memberAbilities(Collection<MemberAbility> var1);

        public Builder memberAbilities(MemberAbility ... var1);

        public Builder queryLogStatus(String var1);

        public Builder queryLogStatus(MembershipQueryLogStatus var1);

        public Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration var1);

        default public Builder defaultResultConfiguration(Consumer<MembershipProtectedQueryResultConfiguration.Builder> defaultResultConfiguration) {
            return this.defaultResultConfiguration((MembershipProtectedQueryResultConfiguration)((MembershipProtectedQueryResultConfiguration.Builder)MembershipProtectedQueryResultConfiguration.builder().applyMutation(defaultResultConfiguration)).build());
        }
    }
}

