/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationsResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListCollaborationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationsResponse.getter(ListCollaborationsResponse::nextToken)).setter(ListCollaborationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationSummary>> COLLABORATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationList").getter(ListCollaborationsResponse.getter(ListCollaborationsResponse::collaborationList)).setter(ListCollaborationsResponse.setter(Builder::collaborationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_LIST_FIELD));
    private final String nextToken;
    private final List<CollaborationSummary> collaborationList;

    private ListCollaborationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationList = builder.collaborationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationList() {
        return this.collaborationList != null && !(this.collaborationList instanceof SdkAutoConstructList);
    }

    public final List<CollaborationSummary> collaborationList() {
        return this.collaborationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationList() ? this.collaborationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationsResponse)) {
            return false;
        }
        ListCollaborationsResponse other = (ListCollaborationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationList() == other.hasCollaborationList() && Objects.equals(this.collaborationList(), other.collaborationList());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationList", this.hasCollaborationList() ? this.collaborationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationList": {
                return Optional.ofNullable(clazz.cast(this.collaborationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationsResponse, T> g) {
        return obj -> g.apply((ListCollaborationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationSummary> collaborationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationList(model.collaborationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationSummary.Builder> getCollaborationList() {
            List<CollaborationSummary.Builder> result = CollaborationSummaryListCopier.copyToBuilder(this.collaborationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationList(Collection<CollaborationSummary.BuilderImpl> collaborationList) {
            this.collaborationList = CollaborationSummaryListCopier.copyFromBuilder(collaborationList);
        }

        @Override
        public final Builder collaborationList(Collection<CollaborationSummary> collaborationList) {
            this.collaborationList = CollaborationSummaryListCopier.copy(collaborationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationList(CollaborationSummary ... collaborationList) {
            this.collaborationList(Arrays.asList(collaborationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationList(Consumer<CollaborationSummary.Builder> ... collaborationList) {
            this.collaborationList(Stream.of(collaborationList).map(c -> (CollaborationSummary)((CollaborationSummary.Builder)CollaborationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationsResponse build() {
            return new ListCollaborationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationList(Collection<CollaborationSummary> var1);

        public Builder collaborationList(CollaborationSummary ... var1);

        public Builder collaborationList(Consumer<CollaborationSummary.Builder> ... var1);
    }
}

