/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesResponse;

public class ListConfiguredTablesIterable
implements SdkIterable<ListConfiguredTablesResponse> {
    private final CleanRoomsClient client;
    private final ListConfiguredTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfiguredTablesIterable(CleanRoomsClient client, ListConfiguredTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConfiguredTablesResponseFetcher();
    }

    public Iterator<ListConfiguredTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfiguredTableSummary> configuredTableSummaries() {
        Function<ListConfiguredTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredTableSummaries() != null) {
                return response.configuredTableSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfiguredTablesResponseFetcher
    implements SyncPageFetcher<ListConfiguredTablesResponse> {
        private ListConfiguredTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfiguredTablesResponse nextPage(ListConfiguredTablesResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredTablesIterable.this.client.listConfiguredTables(ListConfiguredTablesIterable.this.firstRequest);
            }
            return ListConfiguredTablesIterable.this.client.listConfiguredTables((ListConfiguredTablesRequest)((Object)ListConfiguredTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

