/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse;

public class ListProxySessionsIterable
implements SdkIterable<ListProxySessionsResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListProxySessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProxySessionsIterable(ChimeSdkVoiceClient client, ListProxySessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProxySessionsResponseFetcher();
    }

    public Iterator<ListProxySessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProxySessionsResponseFetcher
    implements SyncPageFetcher<ListProxySessionsResponse> {
        private ListProxySessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProxySessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProxySessionsResponse nextPage(ListProxySessionsResponse previousPage) {
            if (previousPage == null) {
                return ListProxySessionsIterable.this.client.listProxySessions(ListProxySessionsIterable.this.firstRequest);
            }
            return ListProxySessionsIterable.this.client.listProxySessions((ListProxySessionsRequest)((Object)ListProxySessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

