/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication;

public class ListSipMediaApplicationsPublisher
implements SdkPublisher<ListSipMediaApplicationsResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final ListSipMediaApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSipMediaApplicationsPublisher(ChimeSdkVoiceAsyncClient client, ListSipMediaApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSipMediaApplicationsPublisher(ChimeSdkVoiceAsyncClient client, ListSipMediaApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSipMediaApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSipMediaApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SipMediaApplication> sipMediaApplications() {
        Function<ListSipMediaApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sipMediaApplications() != null) {
                return response.sipMediaApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSipMediaApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSipMediaApplicationsResponseFetcher
    implements AsyncPageFetcher<ListSipMediaApplicationsResponse> {
        private ListSipMediaApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSipMediaApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSipMediaApplicationsResponse> nextPage(ListSipMediaApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSipMediaApplicationsPublisher.this.client.listSipMediaApplications(ListSipMediaApplicationsPublisher.this.firstRequest);
            }
            return ListSipMediaApplicationsPublisher.this.client.listSipMediaApplications((ListSipMediaApplicationsRequest)((Object)ListSipMediaApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

