/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse;

public class ListVoiceProfilesIterable
implements SdkIterable<ListVoiceProfilesResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListVoiceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVoiceProfilesIterable(ChimeSdkVoiceClient client, ListVoiceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVoiceProfilesResponseFetcher();
    }

    public Iterator<ListVoiceProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVoiceProfilesResponseFetcher
    implements SyncPageFetcher<ListVoiceProfilesResponse> {
        private ListVoiceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVoiceProfilesResponse nextPage(ListVoiceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceProfilesIterable.this.client.listVoiceProfiles(ListVoiceProfilesIterable.this.firstRequest);
            }
            return ListVoiceProfilesIterable.this.client.listVoiceProfiles((ListVoiceProfilesRequest)((Object)ListVoiceProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

