/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse;

public class ListVoiceConnectorsIterable
implements SdkIterable<ListVoiceConnectorsResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListVoiceConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVoiceConnectorsIterable(ChimeSdkVoiceClient client, ListVoiceConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVoiceConnectorsResponseFetcher();
    }

    public Iterator<ListVoiceConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVoiceConnectorsResponseFetcher
    implements SyncPageFetcher<ListVoiceConnectorsResponse> {
        private ListVoiceConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVoiceConnectorsResponse nextPage(ListVoiceConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceConnectorsIterable.this.client.listVoiceConnectors(ListVoiceConnectorsIterable.this.firstRequest);
            }
            return ListVoiceConnectorsIterable.this.client.listVoiceConnectors((ListVoiceConnectorsRequest)((Object)ListVoiceConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

