/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.Capability;
import software.amazon.awssdk.services.chimesdkvoice.model.CapabilityListCopier;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxySessionRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, UpdateProxySessionRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(UpdateProxySessionRequest.getter(UpdateProxySessionRequest::voiceConnectorId)).setter(UpdateProxySessionRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<String> PROXY_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxySessionId").getter(UpdateProxySessionRequest.getter(UpdateProxySessionRequest::proxySessionId)).setter(UpdateProxySessionRequest.setter(Builder::proxySessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("proxySessionId").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(UpdateProxySessionRequest.getter(UpdateProxySessionRequest::capabilitiesAsStrings)).setter(UpdateProxySessionRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> EXPIRY_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpiryMinutes").getter(UpdateProxySessionRequest.getter(UpdateProxySessionRequest::expiryMinutes)).setter(UpdateProxySessionRequest.setter(Builder::expiryMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, PROXY_SESSION_ID_FIELD, CAPABILITIES_FIELD, EXPIRY_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
            this.put("proxySessionId", PROXY_SESSION_ID_FIELD);
            this.put("Capabilities", CAPABILITIES_FIELD);
            this.put("ExpiryMinutes", EXPIRY_MINUTES_FIELD);
        }
    });
    private final String voiceConnectorId;
    private final String proxySessionId;
    private final List<String> capabilities;
    private final Integer expiryMinutes;

    private UpdateProxySessionRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.proxySessionId = builder.proxySessionId;
        this.capabilities = builder.capabilities;
        this.expiryMinutes = builder.expiryMinutes;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final String proxySessionId() {
        return this.proxySessionId;
    }

    public final List<Capability> capabilities() {
        return CapabilityListCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final Integer expiryMinutes() {
        return this.expiryMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxySessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxySessionRequest)) {
            return false;
        }
        UpdateProxySessionRequest other = (UpdateProxySessionRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.proxySessionId(), other.proxySessionId()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.expiryMinutes(), other.expiryMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxySessionRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("ProxySessionId", (Object)this.proxySessionId()).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("ExpiryMinutes", (Object)this.expiryMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "ProxySessionId": {
                return Optional.ofNullable(clazz.cast(this.proxySessionId()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "ExpiryMinutes": {
                return Optional.ofNullable(clazz.cast(this.expiryMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxySessionRequest, T> g) {
        return obj -> g.apply((UpdateProxySessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private String proxySessionId;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private Integer expiryMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxySessionRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.proxySessionId(model.proxySessionId);
            this.capabilitiesWithStrings(model.capabilities);
            this.expiryMinutes(model.expiryMinutes);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getProxySessionId() {
            return this.proxySessionId;
        }

        public final void setProxySessionId(String proxySessionId) {
            this.proxySessionId = proxySessionId;
        }

        @Override
        public final Builder proxySessionId(String proxySessionId) {
            this.proxySessionId = proxySessionId;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilityListCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Integer getExpiryMinutes() {
            return this.expiryMinutes;
        }

        public final void setExpiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
        }

        @Override
        public final Builder expiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxySessionRequest build() {
            return new UpdateProxySessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxySessionRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder proxySessionId(String var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder expiryMinutes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

