/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSupportedPhoneNumberCountriesRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, ListSupportedPhoneNumberCountriesRequest> {
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(ListSupportedPhoneNumberCountriesRequest.getter(ListSupportedPhoneNumberCountriesRequest::productTypeAsString)).setter(ListSupportedPhoneNumberCountriesRequest.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("product-type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("product-type", PRODUCT_TYPE_FIELD);
        }
    });
    private final String productType;

    private ListSupportedPhoneNumberCountriesRequest(BuilderImpl builder) {
        super(builder);
        this.productType = builder.productType;
    }

    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedPhoneNumberCountriesRequest)) {
            return false;
        }
        ListSupportedPhoneNumberCountriesRequest other = (ListSupportedPhoneNumberCountriesRequest)((Object)obj);
        return Objects.equals(this.productTypeAsString(), other.productTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListSupportedPhoneNumberCountriesRequest").add("ProductType", (Object)this.productTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedPhoneNumberCountriesRequest, T> g) {
        return obj -> g.apply((ListSupportedPhoneNumberCountriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String productType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedPhoneNumberCountriesRequest model) {
            super(model);
            this.productType(model.productType);
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSupportedPhoneNumberCountriesRequest build() {
            return new ListSupportedPhoneNumberCountriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSupportedPhoneNumberCountriesRequest> {
        public Builder productType(String var1);

        public Builder productType(PhoneNumberProductType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

