/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DNISEmergencyCallingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DNISEmergencyCallingConfiguration> {
    private static final SdkField<String> EMERGENCY_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmergencyPhoneNumber").getter(DNISEmergencyCallingConfiguration.getter(DNISEmergencyCallingConfiguration::emergencyPhoneNumber)).setter(DNISEmergencyCallingConfiguration.setter(Builder::emergencyPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmergencyPhoneNumber").build()}).build();
    private static final SdkField<String> TEST_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TestPhoneNumber").getter(DNISEmergencyCallingConfiguration.getter(DNISEmergencyCallingConfiguration::testPhoneNumber)).setter(DNISEmergencyCallingConfiguration.setter(Builder::testPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestPhoneNumber").build()}).build();
    private static final SdkField<String> CALLING_COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallingCountry").getter(DNISEmergencyCallingConfiguration.getter(DNISEmergencyCallingConfiguration::callingCountry)).setter(DNISEmergencyCallingConfiguration.setter(Builder::callingCountry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingCountry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMERGENCY_PHONE_NUMBER_FIELD, TEST_PHONE_NUMBER_FIELD, CALLING_COUNTRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String emergencyPhoneNumber;
    private final String testPhoneNumber;
    private final String callingCountry;

    private DNISEmergencyCallingConfiguration(BuilderImpl builder) {
        this.emergencyPhoneNumber = builder.emergencyPhoneNumber;
        this.testPhoneNumber = builder.testPhoneNumber;
        this.callingCountry = builder.callingCountry;
    }

    public final String emergencyPhoneNumber() {
        return this.emergencyPhoneNumber;
    }

    public final String testPhoneNumber() {
        return this.testPhoneNumber;
    }

    public final String callingCountry() {
        return this.callingCountry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emergencyPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.testPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.callingCountry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNISEmergencyCallingConfiguration)) {
            return false;
        }
        DNISEmergencyCallingConfiguration other = (DNISEmergencyCallingConfiguration)obj;
        return Objects.equals(this.emergencyPhoneNumber(), other.emergencyPhoneNumber()) && Objects.equals(this.testPhoneNumber(), other.testPhoneNumber()) && Objects.equals(this.callingCountry(), other.callingCountry());
    }

    public final String toString() {
        return ToString.builder((String)"DNISEmergencyCallingConfiguration").add("EmergencyPhoneNumber", (Object)(this.emergencyPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("TestPhoneNumber", (Object)(this.testPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("CallingCountry", (Object)this.callingCountry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmergencyPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.emergencyPhoneNumber()));
            }
            case "TestPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.testPhoneNumber()));
            }
            case "CallingCountry": {
                return Optional.ofNullable(clazz.cast(this.callingCountry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DNISEmergencyCallingConfiguration, T> g) {
        return obj -> g.apply((DNISEmergencyCallingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emergencyPhoneNumber;
        private String testPhoneNumber;
        private String callingCountry;

        private BuilderImpl() {
        }

        private BuilderImpl(DNISEmergencyCallingConfiguration model) {
            this.emergencyPhoneNumber(model.emergencyPhoneNumber);
            this.testPhoneNumber(model.testPhoneNumber);
            this.callingCountry(model.callingCountry);
        }

        public final String getEmergencyPhoneNumber() {
            return this.emergencyPhoneNumber;
        }

        public final void setEmergencyPhoneNumber(String emergencyPhoneNumber) {
            this.emergencyPhoneNumber = emergencyPhoneNumber;
        }

        @Override
        public final Builder emergencyPhoneNumber(String emergencyPhoneNumber) {
            this.emergencyPhoneNumber = emergencyPhoneNumber;
            return this;
        }

        public final String getTestPhoneNumber() {
            return this.testPhoneNumber;
        }

        public final void setTestPhoneNumber(String testPhoneNumber) {
            this.testPhoneNumber = testPhoneNumber;
        }

        @Override
        public final Builder testPhoneNumber(String testPhoneNumber) {
            this.testPhoneNumber = testPhoneNumber;
            return this;
        }

        public final String getCallingCountry() {
            return this.callingCountry;
        }

        public final void setCallingCountry(String callingCountry) {
            this.callingCountry = callingCountry;
        }

        @Override
        public final Builder callingCountry(String callingCountry) {
            this.callingCountry = callingCountry;
            return this;
        }

        public DNISEmergencyCallingConfiguration build() {
            return new DNISEmergencyCallingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DNISEmergencyCallingConfiguration> {
        public Builder emergencyPhoneNumber(String var1);

        public Builder testPhoneNumber(String var1);

        public Builder callingCountry(String var1);
    }
}

