/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpoint;
import software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationEndpointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SipMediaApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SipMediaApplication> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipMediaApplicationId").getter(SipMediaApplication.getter(SipMediaApplication::sipMediaApplicationId)).setter(SipMediaApplication.setter(Builder::sipMediaApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipMediaApplicationId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(SipMediaApplication.getter(SipMediaApplication::awsRegion)).setter(SipMediaApplication.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SipMediaApplication.getter(SipMediaApplication::name)).setter(SipMediaApplication.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<SipMediaApplicationEndpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(SipMediaApplication.getter(SipMediaApplication::endpoints)).setter(SipMediaApplication.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipMediaApplicationEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(SipMediaApplication.getter(SipMediaApplication::createdTimestamp)).setter(SipMediaApplication.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(SipMediaApplication.getter(SipMediaApplication::updatedTimestamp)).setter(SipMediaApplication.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipMediaApplicationArn").getter(SipMediaApplication.getter(SipMediaApplication::sipMediaApplicationArn)).setter(SipMediaApplication.setter(Builder::sipMediaApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipMediaApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_MEDIA_APPLICATION_ID_FIELD, AWS_REGION_FIELD, NAME_FIELD, ENDPOINTS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, SIP_MEDIA_APPLICATION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sipMediaApplicationId;
    private final String awsRegion;
    private final String name;
    private final List<SipMediaApplicationEndpoint> endpoints;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final String sipMediaApplicationArn;

    private SipMediaApplication(BuilderImpl builder) {
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.awsRegion = builder.awsRegion;
        this.name = builder.name;
        this.endpoints = builder.endpoints;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.sipMediaApplicationArn = builder.sipMediaApplicationArn;
    }

    public final String sipMediaApplicationId() {
        return this.sipMediaApplicationId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<SipMediaApplicationEndpoint> endpoints() {
        return this.endpoints;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final String sipMediaApplicationArn() {
        return this.sipMediaApplicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.sipMediaApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipMediaApplication)) {
            return false;
        }
        SipMediaApplication other = (SipMediaApplication)obj;
        return Objects.equals(this.sipMediaApplicationId(), other.sipMediaApplicationId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.name(), other.name()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.sipMediaApplicationArn(), other.sipMediaApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"SipMediaApplication").add("SipMediaApplicationId", (Object)this.sipMediaApplicationId()).add("AwsRegion", (Object)this.awsRegion()).add("Name", (Object)this.name()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("SipMediaApplicationArn", (Object)this.sipMediaApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SipMediaApplicationId": {
                return Optional.ofNullable(clazz.cast(this.sipMediaApplicationId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "SipMediaApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.sipMediaApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipMediaApplication, T> g) {
        return obj -> g.apply((SipMediaApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sipMediaApplicationId;
        private String awsRegion;
        private String name;
        private List<SipMediaApplicationEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private String sipMediaApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SipMediaApplication model) {
            this.sipMediaApplicationId(model.sipMediaApplicationId);
            this.awsRegion(model.awsRegion);
            this.name(model.name);
            this.endpoints(model.endpoints);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.sipMediaApplicationArn(model.sipMediaApplicationArn);
        }

        public final String getSipMediaApplicationId() {
            return this.sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<SipMediaApplicationEndpoint.Builder> getEndpoints() {
            List<SipMediaApplicationEndpoint.Builder> result = SipMediaApplicationEndpointListCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<SipMediaApplicationEndpoint.BuilderImpl> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(SipMediaApplicationEndpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (SipMediaApplicationEndpoint)((SipMediaApplicationEndpoint.Builder)SipMediaApplicationEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final String getSipMediaApplicationArn() {
            return this.sipMediaApplicationArn;
        }

        public final void setSipMediaApplicationArn(String sipMediaApplicationArn) {
            this.sipMediaApplicationArn = sipMediaApplicationArn;
        }

        @Override
        public final Builder sipMediaApplicationArn(String sipMediaApplicationArn) {
            this.sipMediaApplicationArn = sipMediaApplicationArn;
            return this;
        }

        public SipMediaApplication build() {
            return new SipMediaApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SipMediaApplication> {
        public Builder sipMediaApplicationId(String var1);

        public Builder awsRegion(String var1);

        public Builder name(String var1);

        public Builder endpoints(Collection<SipMediaApplicationEndpoint> var1);

        public Builder endpoints(SipMediaApplicationEndpoint ... var1);

        public Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder sipMediaApplicationArn(String var1);
    }
}

