/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SipRule;
import software.amazon.awssdk.services.chimesdkvoice.model.SipRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSipRulesResponse
extends ChimeSdkVoiceResponse
implements ToCopyableBuilder<Builder, ListSipRulesResponse> {
    private static final SdkField<List<SipRule>> SIP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SipRules").getter(ListSipRulesResponse.getter(ListSipRulesResponse::sipRules)).setter(ListSipRulesResponse.setter(Builder::sipRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSipRulesResponse.getter(ListSipRulesResponse::nextToken)).setter(ListSipRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_RULES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SipRule> sipRules;
    private final String nextToken;

    private ListSipRulesResponse(BuilderImpl builder) {
        super(builder);
        this.sipRules = builder.sipRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSipRules() {
        return this.sipRules != null && !(this.sipRules instanceof SdkAutoConstructList);
    }

    public final List<SipRule> sipRules() {
        return this.sipRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSipRules() ? this.sipRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSipRulesResponse)) {
            return false;
        }
        ListSipRulesResponse other = (ListSipRulesResponse)((Object)obj);
        return this.hasSipRules() == other.hasSipRules() && Objects.equals(this.sipRules(), other.sipRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSipRulesResponse").add("SipRules", this.hasSipRules() ? this.sipRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SipRules": {
                return Optional.ofNullable(clazz.cast(this.sipRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSipRulesResponse, T> g) {
        return obj -> g.apply((ListSipRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceResponse.BuilderImpl
    implements Builder {
        private List<SipRule> sipRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSipRulesResponse model) {
            super(model);
            this.sipRules(model.sipRules);
            this.nextToken(model.nextToken);
        }

        public final List<SipRule.Builder> getSipRules() {
            List<SipRule.Builder> result = SipRuleListCopier.copyToBuilder(this.sipRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSipRules(Collection<SipRule.BuilderImpl> sipRules) {
            this.sipRules = SipRuleListCopier.copyFromBuilder(sipRules);
        }

        @Override
        public final Builder sipRules(Collection<SipRule> sipRules) {
            this.sipRules = SipRuleListCopier.copy(sipRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipRules(SipRule ... sipRules) {
            this.sipRules(Arrays.asList(sipRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipRules(Consumer<SipRule.Builder> ... sipRules) {
            this.sipRules(Stream.of(sipRules).map(c -> (SipRule)((SipRule.Builder)SipRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSipRulesResponse build() {
            return new ListSipRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSipRulesResponse> {
        public Builder sipRules(Collection<SipRule> var1);

        public Builder sipRules(SipRule ... var1);

        public Builder sipRules(Consumer<SipRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

