/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClientBuilder;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceServiceClientConfiguration;
import software.amazon.awssdk.services.chimesdkvoice.DefaultChimeSdkVoiceBaseClientBuilder;
import software.amazon.awssdk.services.chimesdkvoice.DefaultChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.endpoints.ChimeSdkVoiceEndpointProvider;

@SdkInternalApi
final class DefaultChimeSdkVoiceClientBuilder
extends DefaultChimeSdkVoiceBaseClientBuilder<ChimeSdkVoiceClientBuilder, ChimeSdkVoiceClient>
implements ChimeSdkVoiceClientBuilder {
    DefaultChimeSdkVoiceClientBuilder() {
    }

    @Override
    public DefaultChimeSdkVoiceClientBuilder endpointProvider(ChimeSdkVoiceEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ChimeSdkVoiceClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultChimeSdkVoiceClientBuilder.validateClientOptions(clientConfiguration);
        ChimeSdkVoiceServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultChimeSdkVoiceClient client = new DefaultChimeSdkVoiceClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ChimeSdkVoiceServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ChimeSdkVoiceServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

