/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of voice profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceProfileDomain implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceProfileDomain.Builder, VoiceProfileDomain> {
    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainId").getter(getter(VoiceProfileDomain::voiceProfileDomainId))
            .setter(setter(Builder::voiceProfileDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainId").build())
            .build();

    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileDomainArn").getter(getter(VoiceProfileDomain::voiceProfileDomainArn))
            .setter(setter(Builder::voiceProfileDomainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VoiceProfileDomain::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(VoiceProfileDomain::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerSideEncryptionConfiguration")
            .getter(getter(VoiceProfileDomain::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(VoiceProfileDomain::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(VoiceProfileDomain::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_PROFILE_DOMAIN_ID_FIELD,
            VOICE_PROFILE_DOMAIN_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD,
            CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String voiceProfileDomainId;

    private final String voiceProfileDomainArn;

    private final String name;

    private final String description;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private VoiceProfileDomain(BuilderImpl builder) {
        this.voiceProfileDomainId = builder.voiceProfileDomainId;
        this.voiceProfileDomainArn = builder.voiceProfileDomainArn;
        this.name = builder.name;
        this.description = builder.description;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ID of the voice profile domain.
     * </p>
     * 
     * @return The ID of the voice profile domain.
     */
    public final String voiceProfileDomainId() {
        return voiceProfileDomainId;
    }

    /**
     * <p>
     * The voice profile domain's Amazon Resource Number (ARN).
     * </p>
     * 
     * @return The voice profile domain's Amazon Resource Number (ARN).
     */
    public final String voiceProfileDomainArn() {
        return voiceProfileDomainArn;
    }

    /**
     * <p>
     * The name of the voice profile domain.
     * </p>
     * 
     * @return The name of the voice profile domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the voice profile domain.
     * </p>
     * 
     * @return The description of the voice profile domain.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A structure that contains the configuration settings for server-side encryption.
     * </p>
     * 
     * @return A structure that contains the configuration settings for server-side encryption.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The time at which the voice profile domain was created.
     * </p>
     * 
     * @return The time at which the voice profile domain was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the voice profile was last updated.
     * </p>
     * 
     * @return The time at which the voice profile was last updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileDomainArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceProfileDomain)) {
            return false;
        }
        VoiceProfileDomain other = (VoiceProfileDomain) obj;
        return Objects.equals(voiceProfileDomainId(), other.voiceProfileDomainId())
                && Objects.equals(voiceProfileDomainArn(), other.voiceProfileDomainArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceProfileDomain").add("VoiceProfileDomainId", voiceProfileDomainId())
                .add("VoiceProfileDomainArn", voiceProfileDomainArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name()).add("Description", description())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceProfileDomainId":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainId()));
        case "VoiceProfileDomainArn":
            return Optional.ofNullable(clazz.cast(voiceProfileDomainArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceProfileDomain, T> g) {
        return obj -> g.apply((VoiceProfileDomain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceProfileDomain> {
        /**
         * <p>
         * The ID of the voice profile domain.
         * </p>
         * 
         * @param voiceProfileDomainId
         *        The ID of the voice profile domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainId(String voiceProfileDomainId);

        /**
         * <p>
         * The voice profile domain's Amazon Resource Number (ARN).
         * </p>
         * 
         * @param voiceProfileDomainArn
         *        The voice profile domain's Amazon Resource Number (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileDomainArn(String voiceProfileDomainArn);

        /**
         * <p>
         * The name of the voice profile domain.
         * </p>
         * 
         * @param name
         *        The name of the voice profile domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the voice profile domain.
         * </p>
         * 
         * @param description
         *        The description of the voice profile domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A structure that contains the configuration settings for server-side encryption.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        A structure that contains the configuration settings for server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * A structure that contains the configuration settings for server-side encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The time at which the voice profile domain was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the voice profile domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the voice profile was last updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the voice profile was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String voiceProfileDomainId;

        private String voiceProfileDomainArn;

        private String name;

        private String description;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceProfileDomain model) {
            voiceProfileDomainId(model.voiceProfileDomainId);
            voiceProfileDomainArn(model.voiceProfileDomainArn);
            name(model.name);
            description(model.description);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceProfileDomainId() {
            return voiceProfileDomainId;
        }

        public final void setVoiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
        }

        @Override
        public final Builder voiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
            return this;
        }

        public final String getVoiceProfileDomainArn() {
            return voiceProfileDomainArn;
        }

        public final void setVoiceProfileDomainArn(String voiceProfileDomainArn) {
            this.voiceProfileDomainArn = voiceProfileDomainArn;
        }

        @Override
        public final Builder voiceProfileDomainArn(String voiceProfileDomainArn) {
            this.voiceProfileDomainArn = voiceProfileDomainArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public VoiceProfileDomain build() {
            return new VoiceProfileDomain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
