/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSipMediaApplicationResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<UpdateSipMediaApplicationResponse.Builder, UpdateSipMediaApplicationResponse> {
    private static final SdkField<SipMediaApplication> SIP_MEDIA_APPLICATION_FIELD = SdkField
            .<SipMediaApplication> builder(MarshallingType.SDK_POJO).memberName("SipMediaApplication")
            .getter(getter(UpdateSipMediaApplicationResponse::sipMediaApplication)).setter(setter(Builder::sipMediaApplication))
            .constructor(SipMediaApplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipMediaApplication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_MEDIA_APPLICATION_FIELD));

    private final SipMediaApplication sipMediaApplication;

    private UpdateSipMediaApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplication = builder.sipMediaApplication;
    }

    /**
     * <p>
     * The updated SIP media application’s details.
     * </p>
     * 
     * @return The updated SIP media application’s details.
     */
    public final SipMediaApplication sipMediaApplication() {
        return sipMediaApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSipMediaApplicationResponse)) {
            return false;
        }
        UpdateSipMediaApplicationResponse other = (UpdateSipMediaApplicationResponse) obj;
        return Objects.equals(sipMediaApplication(), other.sipMediaApplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSipMediaApplicationResponse").add("SipMediaApplication", sipMediaApplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplication":
            return Optional.ofNullable(clazz.cast(sipMediaApplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSipMediaApplicationResponse, T> g) {
        return obj -> g.apply((UpdateSipMediaApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSipMediaApplicationResponse> {
        /**
         * <p>
         * The updated SIP media application’s details.
         * </p>
         * 
         * @param sipMediaApplication
         *        The updated SIP media application’s details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplication(SipMediaApplication sipMediaApplication);

        /**
         * <p>
         * The updated SIP media application’s details.
         * </p>
         * This is a convenience method that creates an instance of the {@link SipMediaApplication.Builder} avoiding the
         * need to create one manually via {@link SipMediaApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SipMediaApplication.Builder#build()} is called immediately and
         * its result is passed to {@link #sipMediaApplication(SipMediaApplication)}.
         * 
         * @param sipMediaApplication
         *        a consumer that will call methods on {@link SipMediaApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipMediaApplication(SipMediaApplication)
         */
        default Builder sipMediaApplication(Consumer<SipMediaApplication.Builder> sipMediaApplication) {
            return sipMediaApplication(SipMediaApplication.builder().applyMutation(sipMediaApplication).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private SipMediaApplication sipMediaApplication;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSipMediaApplicationResponse model) {
            super(model);
            sipMediaApplication(model.sipMediaApplication);
        }

        public final SipMediaApplication.Builder getSipMediaApplication() {
            return sipMediaApplication != null ? sipMediaApplication.toBuilder() : null;
        }

        public final void setSipMediaApplication(SipMediaApplication.BuilderImpl sipMediaApplication) {
            this.sipMediaApplication = sipMediaApplication != null ? sipMediaApplication.build() : null;
        }

        @Override
        public final Builder sipMediaApplication(SipMediaApplication sipMediaApplication) {
            this.sipMediaApplication = sipMediaApplication;
            return this;
        }

        @Override
        public UpdateSipMediaApplicationResponse build() {
            return new UpdateSipMediaApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
